/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.wss4j.policyhandlers;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.ws.policy.AssertionInfoMap;
import org.apache.cxf.ws.security.policy.SP11Constants;
import org.apache.cxf.ws.security.policy.SP12Constants;
import org.apache.cxf.ws.security.policy.SPConstants;
import org.apache.cxf.ws.security.policy.model.AlgorithmSuite;
import org.apache.cxf.ws.security.policy.model.IssuedToken;
import org.apache.cxf.ws.security.policy.model.SecureConversationToken;
import org.apache.cxf.ws.security.policy.model.SymmetricBinding;
import org.apache.cxf.ws.security.policy.model.Token;
import org.apache.cxf.ws.security.policy.model.TokenWrapper;
import org.apache.cxf.ws.security.policy.model.X509Token;
import org.apache.cxf.ws.security.tokenstore.SecurityToken;
import org.apache.cxf.ws.security.tokenstore.TokenStore;
import org.apache.cxf.ws.security.wss4j.policyhandlers.AbstractBindingBuilder;
import org.apache.neethi.Assertion;
import org.apache.ws.security.WSEncryptionPart;
import org.apache.ws.security.WSSConfig;
import org.apache.ws.security.WSSecurityEngineResult;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.conversation.ConversationException;
import org.apache.ws.security.handler.WSHandlerResult;
import org.apache.ws.security.message.WSSecBase;
import org.apache.ws.security.message.WSSecDKEncrypt;
import org.apache.ws.security.message.WSSecDKSign;
import org.apache.ws.security.message.WSSecEncrypt;
import org.apache.ws.security.message.WSSecEncryptedKey;
import org.apache.ws.security.message.WSSecHeader;
import org.apache.ws.security.message.WSSecSignature;
import org.apache.ws.security.message.WSSecTimestamp;
import org.apache.ws.security.message.token.SecurityTokenReference;
import org.apache.ws.security.util.Base64;
import org.apache.ws.security.util.WSSecurityUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SymmetricBindingHandler
extends AbstractBindingBuilder {
    SymmetricBinding sbinding;
    TokenStore tokenStore;

    public SymmetricBindingHandler(WSSConfig config, SymmetricBinding binding, SOAPMessage saaj, WSSecHeader secHeader, AssertionInfoMap aim, SoapMessage message) {
        super(config, binding, saaj, secHeader, aim, message);
        this.sbinding = binding;
        this.tokenStore = this.getTokenStore();
        this.protectionOrder = binding.getProtectionOrder();
    }

    private TokenWrapper getSignatureToken() {
        if (this.sbinding.getProtectionToken() != null) {
            return this.sbinding.getProtectionToken();
        }
        return this.sbinding.getSignatureToken();
    }

    private TokenWrapper getEncryptionToken() {
        if (this.sbinding.getProtectionToken() != null) {
            return this.sbinding.getProtectionToken();
        }
        return this.sbinding.getEncryptionToken();
    }

    public void handleBinding() {
        WSSecTimestamp timestamp = this.createTimestamp();
        this.handleLayout(timestamp);
        if (this.isRequestor()) {
            this.initializeTokens();
        }
        if (this.sbinding.getProtectionOrder() == SPConstants.ProtectionOrder.EncryptBeforeSigning) {
            this.doEncryptBeforeSign();
        } else {
            this.doSignBeforeEncrypt();
        }
        this.policyAsserted(SP11Constants.TRUST_10);
        this.policyAsserted(SP12Constants.TRUST_13);
    }

    private void initializeTokens() {
        Token sigTok = this.getSignatureToken().getToken();
        if (sigTok instanceof IssuedToken || sigTok instanceof SecureConversationToken) {
            // empty if block
        }
    }

    private void doEncryptBeforeSign() {
        try {
            TokenWrapper encryptionWrapper = this.getEncryptionToken();
            Token encryptionToken = encryptionWrapper.getToken();
            List<WSEncryptionPart> encrParts = this.getEncryptedParts();
            List<WSEncryptionPart> sigParts = this.getSignedParts();
            if (encryptionToken != null || encrParts.size() > 0) {
                // empty if block
            }
            if (encryptionToken != null && encrParts.size() > 0) {
                Element el;
                String tokenId = null;
                SecurityToken tok = null;
                if (encryptionToken instanceof IssuedToken) {
                    tok = this.getSecurityToken();
                } else if (encryptionToken instanceof SecureConversationToken) {
                    tok = this.getSecurityToken();
                } else if (encryptionToken instanceof X509Token) {
                    tokenId = this.isRequestor() ? this.setupEncryptedKey(encryptionWrapper, encryptionToken) : this.getEncryptedKey();
                }
                if (tok == null) {
                    if (tokenId == null || tokenId.length() == 0) {
                        // empty if block
                    }
                    if (tokenId.startsWith("#")) {
                        tokenId = tokenId.substring(1);
                    }
                    tok = this.tokenStore.getToken(tokenId);
                }
                boolean attached = false;
                if (SPConstants.IncludeTokenType.INCLUDE_TOKEN_ALWAYS == encryptionToken.getInclusion() || SPConstants.IncludeTokenType.INCLUDE_TOKEN_ONCE == encryptionToken.getInclusion() || this.isRequestor() && SPConstants.IncludeTokenType.INCLUDE_TOKEN_ALWAYS_TO_RECIPIENT == encryptionToken.getInclusion()) {
                    el = tok.getToken();
                    this.addEncryptedKeyElement(this.cloneElement(el));
                    attached = true;
                } else if (encryptionToken instanceof X509Token && this.isRequestor()) {
                    el = tok.getToken();
                    this.addEncryptedKeyElement(this.cloneElement(el));
                    attached = true;
                }
                WSSecBase encr = this.doEncryption(encryptionWrapper, tok, attached, encrParts, true);
                this.handleEncryptedSignedHeaders(encrParts, sigParts);
                if (this.timestampEl != null) {
                    WSEncryptionPart timestampPart = this.convertToEncryptionPart(this.timestampEl.getElement());
                    sigParts.add(timestampPart);
                }
                if (this.isRequestor()) {
                    this.addSupportingTokens(sigParts);
                } else {
                    this.addSignatureConfirmation(sigParts);
                }
                if (sigParts.size() > 0) {
                    this.signatures.add(this.doSignature(sigParts, encryptionWrapper, encryptionToken, tok, attached));
                }
                if (this.isRequestor()) {
                    this.doEndorse();
                }
                if (this.sbinding.isSignatureProtection() && this.mainSigId != null || this.encryptedTokensIdList.size() > 0 && this.isRequestor()) {
                    ArrayList<WSEncryptionPart> secondEncrParts = new ArrayList<WSEncryptionPart>();
                    if (this.sbinding.isSignatureProtection()) {
                        WSEncryptionPart sigPart = new WSEncryptionPart(this.mainSigId, "Element");
                        sigPart.setElement(this.bottomUpElement);
                        secondEncrParts.add(sigPart);
                    }
                    if (this.isRequestor()) {
                        for (String s : this.encryptedTokensIdList) {
                            secondEncrParts.add(new WSEncryptionPart(s, "Element"));
                        }
                    }
                    Element secondRefList = null;
                    if (encryptionToken.isDerivedKeys()) {
                        secondRefList = ((WSSecDKEncrypt)encr).encryptForExternalRef(null, secondEncrParts);
                        this.addDerivedKeyElement(secondRefList);
                    } else {
                        secondRefList = ((WSSecEncrypt)encr).encryptForRef(null, encrParts);
                        this.addDerivedKeyElement(secondRefList);
                    }
                }
            }
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new Fault(ex);
        }
    }

    private void doSignBeforeEncrypt() {
        TokenWrapper sigTokenWrapper = this.getSignatureToken();
        Token sigToken = sigTokenWrapper.getToken();
        String sigTokId = null;
        Element sigTokElem = null;
        try {
            Element el;
            SecurityToken sigTok = null;
            if (sigToken != null) {
                if (sigToken instanceof SecureConversationToken) {
                    sigTok = this.getSecurityToken();
                } else if (sigToken instanceof IssuedToken) {
                    sigTok = this.getSecurityToken();
                } else if (sigToken instanceof X509Token) {
                    sigTokId = this.isRequestor() ? this.setupEncryptedKey(sigTokenWrapper, sigToken) : this.getEncryptedKey();
                }
            } else {
                this.policyNotAsserted((Assertion)this.sbinding, "No signature token");
                return;
            }
            if (sigTok == null && StringUtils.isEmpty(sigTokId)) {
                this.policyNotAsserted((Assertion)sigTokenWrapper, "No signature token id");
                return;
            }
            this.policyAsserted(sigTokenWrapper);
            if (sigTok == null) {
                sigTok = this.tokenStore.getToken(sigTokId);
            }
            if (sigTok == null) {
                // empty if block
            }
            boolean tokIncluded = true;
            if (SPConstants.IncludeTokenType.INCLUDE_TOKEN_ALWAYS == sigToken.getInclusion() || SPConstants.IncludeTokenType.INCLUDE_TOKEN_ONCE == sigToken.getInclusion() || this.isRequestor() && SPConstants.IncludeTokenType.INCLUDE_TOKEN_ALWAYS_TO_RECIPIENT == sigToken.getInclusion()) {
                el = sigTok.getToken();
                sigTokElem = this.cloneElement(el);
                this.addEncryptedKeyElement(sigTokElem);
            } else if (this.isRequestor() && sigToken instanceof X509Token) {
                el = sigTok.getToken();
                sigTokElem = (Element)this.secHeader.getSecurityHeader().getOwnerDocument().importNode(el, true);
                this.addEncryptedKeyElement(sigTokElem);
            } else {
                tokIncluded = false;
            }
            List<WSEncryptionPart> sigs = this.getSignedParts();
            if (this.timestampEl != null) {
                WSEncryptionPart timestampPart = this.convertToEncryptionPart(this.timestampEl.getElement());
                sigs.add(timestampPart);
            }
            if (this.isRequestor()) {
                this.addSupportingTokens(sigs);
                if (!sigs.isEmpty()) {
                    this.signatures.add(this.doSignature(sigs, sigTokenWrapper, sigToken, sigTok, tokIncluded));
                }
                this.doEndorse();
            } else {
                this.assertSupportingTokens(sigs);
                this.addSignatureConfirmation(sigs);
                if (!sigs.isEmpty()) {
                    this.doSignature(sigs, sigTokenWrapper, sigToken, sigTok, tokIncluded);
                }
            }
            TokenWrapper encrTokenWrapper = this.getEncryptionToken();
            Token encrToken = encrTokenWrapper.getToken();
            SecurityToken encrTok = null;
            if (sigToken.equals(encrToken)) {
                encrTok = sigTok;
            } else {
                String encrTokId = null;
                encrTok = this.tokenStore.getToken(encrTokId);
                if (SPConstants.IncludeTokenType.INCLUDE_TOKEN_ALWAYS == encrToken.getInclusion() || SPConstants.IncludeTokenType.INCLUDE_TOKEN_ONCE == encrToken.getInclusion() || this.isRequestor() && SPConstants.IncludeTokenType.INCLUDE_TOKEN_ALWAYS_TO_RECIPIENT == encrToken.getInclusion()) {
                    Element encrTokElem = encrTok.getToken();
                    this.secHeader.getSecurityHeader().insertBefore(encrTokElem, sigTokElem);
                }
            }
            List<WSEncryptionPart> enc = this.getEncryptedParts();
            if (this.sbinding.isSignatureProtection() && this.mainSigId != null) {
                WSEncryptionPart sigPart = new WSEncryptionPart(this.mainSigId, "Element");
                sigPart.setElement(this.bottomUpElement);
                enc.add(sigPart);
            }
            if (this.isRequestor()) {
                for (String id : this.encryptedTokensIdList) {
                    enc.add(new WSEncryptionPart(id, "Element"));
                }
            }
            this.doEncryption(encrTokenWrapper, encrTok, tokIncluded, enc, false);
        }
        catch (Exception e) {
            throw new Fault(e);
        }
    }

    private WSSecBase doEncryptionDerived(TokenWrapper recToken, SecurityToken encrTok, Token encrToken, boolean attached, List<WSEncryptionPart> encrParts, boolean atEnd) {
        try {
            WSSecDKEncrypt dkEncr = new WSSecDKEncrypt(this.wssConfig);
            if (recToken.getToken().getSPConstants() == SP12Constants.INSTANCE) {
                dkEncr.setWscVersion(2);
            }
            if (attached && encrTok.getAttachedReference() != null) {
                dkEncr.setExternalKey(encrTok.getSecret(), (Element)this.saaj.getSOAPPart().importNode((Node)encrTok.getAttachedReference(), true));
            } else if (encrTok.getUnattachedReference() != null) {
                dkEncr.setExternalKey(encrTok.getSecret(), (Element)this.saaj.getSOAPPart().importNode((Node)encrTok.getUnattachedReference(), true));
            } else if (!this.isRequestor()) {
                SecurityTokenReference tokenRef = new SecurityTokenReference((Document)this.saaj.getSOAPPart());
                if (encrTok.getSHA1() != null) {
                    tokenRef.setKeyIdentifierEncKeySHA1(encrTok.getSHA1());
                    tokenRef.addTokenType("http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#EncryptedKey");
                }
                dkEncr.setExternalKey(encrTok.getSecret(), tokenRef.getElement());
            } else if (attached) {
                String id = encrTok.getWsuId();
                if (id == null && encrToken instanceof SecureConversationToken) {
                    dkEncr.setTokenIdDirectId(true);
                    id = encrTok.getId();
                } else if (id == null) {
                    id = encrTok.getId();
                }
                if (id.startsWith("#")) {
                    id = id.substring(1);
                }
                dkEncr.setExternalKey(encrTok.getSecret(), id);
            } else {
                dkEncr.setTokenIdDirectId(true);
                dkEncr.setExternalKey(encrTok.getSecret(), encrTok.getId());
            }
            if (encrTok.getSHA1() != null) {
                dkEncr.setCustomValueType("http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#EncryptedKey");
            } else {
                dkEncr.setCustomValueType(encrTok.getTokenType());
            }
            dkEncr.setSymmetricEncAlgorithm(this.sbinding.getAlgorithmSuite().getEncryption());
            dkEncr.setDerivedKeyLength(this.sbinding.getAlgorithmSuite().getEncryptionDerivedKeyLength() / 8);
            dkEncr.prepare((Document)this.saaj.getSOAPPart());
            Element encrDKTokenElem = null;
            encrDKTokenElem = dkEncr.getdktElement();
            this.addDerivedKeyElement(encrDKTokenElem);
            Element refList = dkEncr.encryptForExternalRef(null, encrParts);
            if (atEnd) {
                this.insertBeforeBottomUp(refList);
            } else {
                this.addDerivedKeyElement(refList);
            }
            return dkEncr;
        }
        catch (Exception e) {
            this.policyNotAsserted((Assertion)recToken, e);
            return null;
        }
    }

    private WSSecBase doEncryption(TokenWrapper recToken, SecurityToken encrTok, boolean attached, List<WSEncryptionPart> encrParts, boolean atEnd) {
        if (recToken != null && recToken.getToken() != null && encrParts.size() > 0) {
            Token encrToken = recToken.getToken();
            this.policyAsserted(recToken);
            this.policyAsserted(encrToken);
            AlgorithmSuite algorithmSuite = this.sbinding.getAlgorithmSuite();
            if (encrToken.isDerivedKeys()) {
                return this.doEncryptionDerived(recToken, encrTok, encrToken, attached, encrParts, atEnd);
            }
            try {
                WSSecEncrypt encr = new WSSecEncrypt(this.wssConfig);
                String encrTokId = encrTok.getId();
                if (attached) {
                    encrTokId = encrTok.getWsuId();
                    if (encrTokId == null && encrToken instanceof SecureConversationToken) {
                        encr.setEncKeyIdDirectId(true);
                        encrTokId = encrTok.getId();
                    } else if (encrTokId == null) {
                        encrTokId = encrTok.getId();
                    }
                    if (encrTokId.startsWith("#")) {
                        encrTokId = encrTokId.substring(1);
                    }
                } else {
                    encr.setEncKeyIdDirectId(true);
                }
                if (encrTok.getTokenType() != null) {
                    encr.setCustomReferenceValue(encrTok.getTokenType());
                }
                encr.setEncKeyId(encrTokId);
                encr.setEphemeralKey(encrTok.getSecret());
                Crypto crypto = this.getEncryptionCrypto(recToken);
                if (crypto != null) {
                    this.message.getExchange().put("ws-security.encryption.crypto", crypto);
                    this.setEncryptionUser((WSSecEncryptedKey)encr, recToken, false, crypto);
                }
                encr.setDocument((Document)this.saaj.getSOAPPart());
                encr.setEncryptSymmKey(false);
                encr.setSymmetricEncAlgorithm(algorithmSuite.getEncryption());
                if (!this.isRequestor()) {
                    if (encrTok.getSHA1() != null) {
                        encr.setCustomReferenceValue(encrTok.getSHA1());
                        encr.setKeyIdentifierType(10);
                    } else {
                        encr.setKeyIdentifierType(6);
                    }
                } else if (encrToken instanceof IssuedToken) {
                    encr.setKeyIdentifierType(12);
                    String tokenType = encrTok.getTokenType();
                    if ("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV1.1".equals(tokenType)) {
                        encr.setCustomReferenceValue("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.0#SAMLAssertionID");
                    } else if ("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV2.0".equals(tokenType)) {
                        encr.setCustomReferenceValue("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLID");
                    } else {
                        encr.setCustomReferenceValue(tokenType);
                    }
                }
                encr.prepare((Document)this.saaj.getSOAPPart(), crypto);
                if (encr.getBSTTokenId() != null) {
                    encr.prependBSTElementToHeader(this.secHeader);
                }
                Element refList = encr.encryptForRef(null, encrParts);
                if (atEnd) {
                    this.insertBeforeBottomUp(refList);
                } else {
                    this.addDerivedKeyElement(refList);
                }
                return encr;
            }
            catch (WSSecurityException e) {
                this.policyNotAsserted((Assertion)recToken, e.getMessage());
            }
        }
        return null;
    }

    private byte[] doSignatureDK(List<WSEncryptionPart> sigs, TokenWrapper policyTokenWrapper, Token policyToken, SecurityToken tok, boolean included) throws WSSecurityException {
        Element ref;
        SOAPPart doc = this.saaj.getSOAPPart();
        WSSecDKSign dkSign = new WSSecDKSign(this.wssConfig);
        if (policyTokenWrapper.getToken().getSPConstants() == SP12Constants.INSTANCE) {
            dkSign.setWscVersion(2);
        }
        boolean attached = false;
        if (SPConstants.IncludeTokenType.INCLUDE_TOKEN_ALWAYS == policyToken.getInclusion() || SPConstants.IncludeTokenType.INCLUDE_TOKEN_ONCE == policyToken.getInclusion() || this.isRequestor() && SPConstants.IncludeTokenType.INCLUDE_TOKEN_ALWAYS_TO_RECIPIENT == policyToken.getInclusion()) {
            attached = true;
        }
        if ((ref = attached ? tok.getAttachedReference() : tok.getUnattachedReference()) != null) {
            dkSign.setExternalKey(tok.getSecret(), (Element)this.saaj.getSOAPPart().importNode((Node)ref, true));
        } else if (!this.isRequestor() && policyToken.isDerivedKeys()) {
            SecurityTokenReference tokenRef = new SecurityTokenReference((Document)doc);
            if (tok.getSHA1() != null) {
                tokenRef.setKeyIdentifierEncKeySHA1(tok.getSHA1());
                tokenRef.addTokenType("http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#EncryptedKey");
            }
            dkSign.setExternalKey(tok.getSecret(), tokenRef.getElement());
        } else {
            if (policyToken instanceof SecureConversationToken) {
                dkSign.setTokenIdDirectId(true);
            }
            dkSign.setExternalKey(tok.getSecret(), tok.getId());
        }
        dkSign.setSignatureAlgorithm(this.sbinding.getAlgorithmSuite().getSymmetricSignature());
        dkSign.setDerivedKeyLength(this.sbinding.getAlgorithmSuite().getSignatureDerivedKeyLength() / 8);
        if (tok.getSHA1() != null) {
            dkSign.setCustomValueType("http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#EncryptedKey");
        } else {
            dkSign.setCustomValueType(tok.getTokenType());
        }
        try {
            dkSign.prepare((Document)doc, this.secHeader);
        }
        catch (ConversationException e) {
            throw new WSSecurityException(e.getMessage(), (Throwable)e);
        }
        if (this.sbinding.isTokenProtection()) {
            String sigTokId = tok.getId();
            if (included) {
                sigTokId = tok.getWsuId();
                if (sigTokId == null) {
                    sigTokId = tok.getId();
                }
                if (sigTokId.startsWith("#")) {
                    sigTokId = sigTokId.substring(1);
                }
            }
            sigs.add(new WSEncryptionPart(sigTokId));
        }
        dkSign.setParts(sigs);
        List referenceList = dkSign.addReferencesToSign(sigs, this.secHeader);
        Element el = dkSign.getdktElement();
        this.addDerivedKeyElement(el);
        if (this.bottomUpElement == null) {
            dkSign.computeSignature(referenceList, false, null);
        } else {
            dkSign.computeSignature(referenceList, true, this.bottomUpElement);
        }
        this.bottomUpElement = dkSign.getSignatureElement();
        this.mainSigId = dkSign.getSignatureId();
        return dkSign.getSignatureValue();
    }

    private byte[] doSignature(List<WSEncryptionPart> sigs, TokenWrapper policyTokenWrapper, Token policyToken, SecurityToken tok, boolean included) throws WSSecurityException {
        String sigTokId;
        int type;
        if (policyToken.isDerivedKeys()) {
            return this.doSignatureDK(sigs, policyTokenWrapper, policyToken, tok, included);
        }
        WSSecSignature sig = new WSSecSignature(this.wssConfig);
        sig.setWsConfig(this.wssConfig);
        int n = type = included ? 9 : 11;
        if (policyToken instanceof X509Token) {
            if (this.isRequestor()) {
                sig.setCustomTokenValueType("http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#EncryptedKey");
                sig.setKeyIdentifierType(type);
            } else {
                sig.setEncrKeySha1value(tok.getSHA1());
                sig.setKeyIdentifierType(10);
            }
        } else {
            String tokenType = tok.getTokenType();
            if ("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV1.1".equals(tokenType)) {
                sig.setCustomTokenValueType("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.0#SAMLAssertionID");
                sig.setKeyIdentifierType(12);
            } else if ("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV2.0".equals(tokenType)) {
                sig.setCustomTokenValueType("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLID");
                sig.setKeyIdentifierType(12);
            } else {
                sig.setCustomTokenValueType(tokenType);
                sig.setKeyIdentifierType(type);
            }
        }
        if (included) {
            sigTokId = tok.getWsuId();
            if (sigTokId == null) {
                if (policyToken instanceof SecureConversationToken) {
                    sig.setKeyIdentifierType(11);
                }
                sigTokId = tok.getId();
            }
            if (sigTokId.startsWith("#")) {
                sigTokId = sigTokId.substring(1);
            }
        } else {
            sigTokId = tok.getId();
        }
        sig.setCustomTokenId(sigTokId);
        sig.setSecretKey(tok.getSecret());
        sig.setSignatureAlgorithm(this.sbinding.getAlgorithmSuite().getSymmetricSignature());
        Crypto crypto = null;
        crypto = this.sbinding.getProtectionToken() != null ? this.getEncryptionCrypto(this.sbinding.getProtectionToken()) : this.getSignatureCrypto(policyTokenWrapper);
        this.message.getExchange().put("ws-security.signature.crypto", crypto);
        sig.prepare((Document)this.saaj.getSOAPPart(), crypto, this.secHeader);
        sig.setParts(sigs);
        List referenceList = sig.addReferencesToSign(sigs, this.secHeader);
        if (this.bottomUpElement == null) {
            sig.computeSignature(referenceList, false, null);
        } else {
            sig.computeSignature(referenceList, true, this.bottomUpElement);
        }
        this.bottomUpElement = sig.getSignatureElement();
        this.mainSigId = sig.getId();
        return sig.getSignatureValue();
    }

    private String setupEncryptedKey(TokenWrapper wrapper, Token sigToken) throws WSSecurityException {
        WSSecEncryptedKey encrKey = this.getEncryptedKeyBuilder(wrapper, sigToken);
        String id = encrKey.getId();
        byte[] secret = encrKey.getEphemeralKey();
        Date created = new Date();
        Date expires = new Date();
        expires.setTime(created.getTime() + 300000L);
        SecurityToken tempTok = new SecurityToken(id, encrKey.getEncryptedKeyElement(), created, expires);
        tempTok.setSecret(secret);
        tempTok.setSHA1(this.getSHA1(encrKey.getEncryptedEphemeralKey()));
        this.tokenStore.add(tempTok);
        String bstTokenId = encrKey.getBSTTokenId();
        if (bstTokenId != null && bstTokenId.length() > 0) {
            encrKey.prependBSTElementToHeader(this.secHeader);
        }
        return id;
    }

    private String getEncryptedKey() {
        List<WSHandlerResult> results = CastUtils.cast((List)this.message.getExchange().getInMessage().get("RECV_RESULTS"));
        for (WSHandlerResult rResult : results) {
            List wsSecEngineResults = rResult.getResults();
            for (WSSecurityEngineResult wser : wsSecEngineResults) {
                Integer actInt = (Integer)wser.get((Object)"action");
                String encryptedKeyID = (String)wser.get((Object)"id");
                if (actInt != 4 || encryptedKeyID == null || encryptedKeyID.length() == 0) continue;
                Date created = new Date();
                Date expires = new Date();
                expires.setTime(created.getTime() + 300000L);
                SecurityToken tempTok = new SecurityToken(encryptedKeyID, created, expires);
                tempTok.setSecret((byte[])wser.get((Object)"secret"));
                tempTok.setSHA1(this.getSHA1((byte[])wser.get((Object)"encrypted-ephemeral-key-bytes")));
                this.tokenStore.add(tempTok);
                return encryptedKeyID;
            }
        }
        return null;
    }

    private String getSHA1(byte[] input) {
        try {
            byte[] digestBytes = WSSecurityUtil.generateDigest((byte[])input);
            return Base64.encode((byte[])digestBytes);
        }
        catch (WSSecurityException wSSecurityException) {
            return null;
        }
    }
}

