/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.helpers;

import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import org.apache.cxf.helpers.JavaUtils;

public final class ServiceUtils {
    private ServiceUtils() {
    }

    public static String makeServiceNameFromClassName(Class<?> clazz) {
        int inner;
        String name = clazz.getName();
        int last = name.lastIndexOf(".");
        if (last != -1) {
            name = name.substring(last + 1);
        }
        if ((inner = name.lastIndexOf("$")) != -1) {
            name = name.substring(inner + 1);
        }
        return name;
    }

    public static QName makeQualifiedNameFromClass(Class<?> clazz) {
        String namespace = ServiceUtils.makeNamespaceFromClassName(clazz.getName(), "http");
        String localPart = ServiceUtils.makeServiceNameFromClassName(clazz);
        return new QName(namespace, localPart);
    }

    public static String getMethodName(Method m) {
        StringBuilder sb = new StringBuilder();
        sb.append(m.getDeclaringClass().getName());
        sb.append('.');
        sb.append(m.getName());
        sb.append('(');
        Class<?>[] params = m.getParameterTypes();
        for (int i = 0; i < params.length; ++i) {
            Class<?> param = params[i];
            sb.append(param.getName());
            if (i >= params.length - 1) continue;
            sb.append(", ");
        }
        sb.append(')');
        return sb.toString();
    }

    public static String makeNamespaceFromClassName(String className, String protocol) {
        int index = className.lastIndexOf(".");
        if (index == -1) {
            return protocol + "://" + "DefaultNamespace";
        }
        String packageName = className.substring(0, index);
        StringTokenizer st = new StringTokenizer(packageName, ".");
        String[] words = new String[st.countTokens()];
        for (int i = 0; i < words.length; ++i) {
            words[i] = st.nextToken();
        }
        StringBuilder sb = new StringBuilder(80);
        for (int i = words.length - 1; i >= 0; --i) {
            String word = words[i];
            if (i != words.length - 1) {
                sb.append('.');
            }
            sb.append(word);
        }
        return protocol + "://" + sb.toString() + "/";
    }

    public static String makePackageName(String namespace) {
        String hostname = null;
        String path = "";
        try {
            URL u = new URL(namespace);
            hostname = u.getHost();
            path = u.getPath();
        }
        catch (MalformedURLException e) {
            if (namespace.indexOf(":") > -1) {
                hostname = namespace.substring(namespace.indexOf(":") + 1);
                if (hostname.indexOf("/") > -1) {
                    hostname = hostname.substring(0, hostname.indexOf("/"));
                }
            }
            hostname = namespace;
        }
        if (hostname == null) {
            return null;
        }
        hostname = hostname.replace('-', '_');
        if ((path = path.replace('-', '_')).length() > 0 && path.charAt(path.length() - 1) == '/') {
            path = path.substring(0, path.length() - 1);
        }
        StringTokenizer st = new StringTokenizer(hostname, ".:");
        String[] words = new String[st.countTokens()];
        for (int i = 0; i < words.length; ++i) {
            words[i] = st.nextToken();
        }
        StringBuilder sb = new StringBuilder(namespace.length());
        for (int i = words.length - 1; i >= 0; --i) {
            ServiceUtils.addWordToPackageBuffer(sb, words[i], i == words.length - 1);
        }
        StringTokenizer st2 = new StringTokenizer(path, "/");
        while (st2.hasMoreTokens()) {
            ServiceUtils.addWordToPackageBuffer(sb, st2.nextToken(), false);
        }
        return sb.toString();
    }

    private static void addWordToPackageBuffer(StringBuilder sb, String word, boolean firstWord) {
        if (JavaUtils.isJavaKeyword(word)) {
            word = JavaUtils.makeNonJavaKeyword(word);
        }
        if (!firstWord) {
            sb.append('.');
        }
        if (Character.isDigit(word.charAt(0))) {
            sb.append('_');
        }
        if (word.indexOf(46) != -1) {
            char[] buf = word.toCharArray();
            for (int i = 0; i < word.length(); ++i) {
                if (buf[i] != '.') continue;
                buf[i] = 95;
            }
            word = new String(buf);
        }
        sb.append(word);
    }
}

