/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.dsb.component.poller;

import java.io.ByteArrayOutputStream;
import java.util.logging.Level;
import javax.jbi.JBIException;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessageExchangeFactory;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.ow2.petals.component.framework.PetalsBindingComponent;
import org.ow2.petals.component.framework.api.Message;
import org.ow2.petals.component.framework.api.message.Exchange;
import org.ow2.petals.component.framework.message.ExchangeImpl;
import org.ow2.petals.component.framework.su.AbstractServiceUnitManager;
import org.petalslink.dsb.component.poller.SUManager;
import org.petalslink.dsb.service.poller.QuartzPollingManagerImpl;
import org.petalslink.dsb.service.poller.api.PollerException;
import org.petalslink.dsb.service.poller.api.PollingManager;
import org.petalslink.dsb.service.poller.api.PollingTransport;
import org.petalslink.dsb.service.poller.api.ServiceInformation;
import org.w3c.dom.Document;

public class Component
extends PetalsBindingComponent
implements PollingTransport {
    private PollingManager pollingManager;

    protected void postDoInit() throws JBIException {
        if (this.pollingManager == null) {
            this.pollingManager = new QuartzPollingManagerImpl();
        }
        try {
            this.pollingManager.init();
        }
        catch (PollerException e) {
            e.printStackTrace();
        }
    }

    protected void doStart() throws JBIException {
        try {
            this.pollingManager.start();
        }
        catch (PollerException e) {
            e.printStackTrace();
        }
    }

    protected void doStop() throws JBIException {
        try {
            this.pollingManager.stop();
        }
        catch (PollerException e) {
            e.printStackTrace();
        }
    }

    protected AbstractServiceUnitManager createServiceUnitManager() {
        return new SUManager(this);
    }

    public Document send(Document inputMessage, ServiceInformation service) throws PollerException {
        if (this.getLogger().isLoggable(Level.FINE)) {
            this.getLogger().fine("Sending a message through the JBI channel...");
            this.getLogger().fine("Destination is " + service);
            try {
                DOMSource source = new DOMSource(inputMessage);
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                TransformerFactory.newInstance().newTransformer().transform(source, new StreamResult(outputStream));
                this.getLogger().fine("Input message is : " + outputStream.toString());
            }
            catch (Exception e) {
                this.getLogger().log(Level.FINE, "Error while creating DOM as String", e.getCause());
            }
        }
        Exchange exchange = null;
        try {
            exchange = this.createMessageExchange();
            exchange.setInMessageContent(inputMessage);
            exchange.setOperation(service.operation);
            exchange.setService(service.service);
            exchange.setInterfaceName(service.itf);
        }
        catch (Exception e) {
            String errorMsg = "Error while transforming request to JBI MessageExchange";
            if (this.getLogger().isLoggable(Level.FINE)) {
                this.getLogger().log(Level.FINE, "Error while transforming request to JBI MessageExchange", e);
            }
            throw new PollerException("Error while transforming request to JBI MessageExchange", (Throwable)e);
        }
        boolean sent = false;
        try {
            sent = this.getChannel().sendSync(((ExchangeImpl)exchange).getMessageExchange());
        }
        catch (MessagingException e) {
            String errorMsg = "Error while sending message through JBI NMR.";
            if (this.getLogger().isLoggable(Level.FINE)) {
                this.getLogger().log(Level.FINE, "Error while sending message through JBI NMR.", e);
            }
            throw new PollerException("Error while sending message through JBI NMR.", (Throwable)e);
        }
        if (!sent) {
            String errorMsg = "A timeout occurs calling the consumed service.";
            if (this.getLogger().isLoggable(Level.FINE)) {
                this.getLogger().log(Level.FINE, errorMsg);
            }
            throw new PollerException(errorMsg);
        }
        return this.processResponse(exchange);
    }

    public void fireAndForget(Document inputMessage, ServiceInformation service) throws PollerException {
    }

    protected Exchange createMessageExchange() throws MessagingException {
        MessageExchangeFactory factory = this.getChannel().createExchangeFactory();
        MessageExchange exchange = factory.createExchange(Message.MEPConstants.IN_OUT_PATTERN.value());
        return new ExchangeImpl(exchange);
    }

    protected void closeMessageExchange(Exchange exchange) throws PollerException {
        try {
            exchange.setDoneStatus();
            this.getChannel().send(((ExchangeImpl)exchange).getMessageExchange());
        }
        catch (MessagingException e) {
            String errorMsg = "Error while closing JBI MessageExchange.";
            throw new PollerException("Error while closing JBI MessageExchange.", (Throwable)e);
        }
    }

    protected Document processResponse(Exchange exchange) throws PollerException {
        Document result = null;
        this.getLogger().fine("Processing response for status " + exchange.getStatus());
        if (exchange.isDoneStatus()) {
            this.getLogger().fine("Done status");
            return null;
        }
        if (exchange.isErrorStatus()) {
            throw new PollerException((Throwable)exchange.getError());
        }
        if (exchange.isActiveStatus()) {
            try {
                if (exchange.getOutMessage() != null) {
                    NormalizedMessage nm = exchange.getOutMessage();
                    if (nm == null) {
                        String errorMsg = "The MEP '" + exchange.getPattern() + "' does not accept a null response";
                        throw new PollerException(errorMsg);
                    }
                    try {
                        result = exchange.getOutMessageContentAsDocument();
                    }
                    catch (MessagingException e) {
                        throw new PollerException(e.getMessage());
                    }
                }
                exchange.getFault();
            }
            finally {
                this.closeMessageExchange(exchange);
            }
        } else {
            String errorMsg = "Bad exchange status";
            if (this.getLogger().isLoggable(Level.FINE)) {
                this.getLogger().log(Level.FINE, errorMsg);
            }
            throw new PollerException(errorMsg);
        }
        if (this.getLogger().isLoggable(Level.FINE)) {
            if (result != null) {
                try {
                    DOMSource source = new DOMSource(result);
                    ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                    TransformerFactory.newInstance().newTransformer().transform(source, new StreamResult(outputStream));
                    this.getLogger().fine("Output message is : " + outputStream.toString());
                }
                catch (Exception e) {
                    this.getLogger().log(Level.FINE, "Error while creating DOM as String", e.getCause());
                }
            } else {
                this.getLogger().fine("Output message is null");
            }
        }
        return result;
    }

    public PollingManager getPollingManager() {
        return this.pollingManager;
    }
}

