/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.converter.xml;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.converter.HttpMessageConversionException;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.HttpMessageNotWritableException;
import org.springframework.http.converter.xml.AbstractXmlHttpMessageConverter;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SourceHttpMessageConverter<T extends Source>
extends AbstractXmlHttpMessageConverter<T> {
    @Override
    public boolean supports(Class<?> clazz) {
        return DOMSource.class.equals(clazz) || SAXSource.class.equals(clazz) || StreamSource.class.equals(clazz) || Source.class.equals(clazz);
    }

    @Override
    protected T readFromSource(Class clazz, HttpHeaders headers, Source source) throws IOException {
        try {
            if (DOMSource.class.equals((Object)clazz)) {
                DOMResult domResult = new DOMResult();
                this.transform(source, domResult);
                return (T)new DOMSource(domResult.getNode());
            }
            if (SAXSource.class.equals((Object)clazz)) {
                ByteArrayInputStream bis = this.transformToByteArrayInputStream(source);
                return (T)new SAXSource(new InputSource(bis));
            }
            if (StreamSource.class.equals((Object)clazz) || Source.class.equals((Object)clazz)) {
                ByteArrayInputStream bis = this.transformToByteArrayInputStream(source);
                return (T)new StreamSource(bis);
            }
            throw new HttpMessageConversionException("Could not read class [" + clazz + "]. Only DOMSource, SAXSource, and StreamSource are supported.");
        }
        catch (TransformerException ex) {
            throw new HttpMessageNotReadableException("Could not transform from [" + source + "] to [" + clazz + "]", ex);
        }
    }

    private ByteArrayInputStream transformToByteArrayInputStream(Source source) throws TransformerException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        this.transform(source, new StreamResult(bos));
        return new ByteArrayInputStream(bos.toByteArray());
    }

    @Override
    protected void writeToResult(T t, HttpHeaders headers, Result result) throws IOException {
        try {
            this.transform((Source)t, result);
        }
        catch (TransformerException ex) {
            throw new HttpMessageNotWritableException("Could not transform [" + t + "] to [" + result + "]", ex);
        }
    }
}

