/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.dsb.notification.service;

import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.utils.WsnbException;
import com.ebmwebsourcing.wsstar.resourceproperties.datatypes.api.abstraction.GetResourcePropertyResponse;
import com.ebmwebsourcing.wsstar.resourceproperties.datatypes.api.abstraction.UpdateResourceProperties;
import com.ebmwebsourcing.wsstar.resourceproperties.datatypes.api.abstraction.UpdateResourcePropertiesResponse;
import com.ebmwebsourcing.wsstar.resourceproperties.datatypes.api.refinedabstraction.RefinedWsrfrpFactory;
import com.ebmwebsourcing.wsstar.resourceproperties.datatypes.api.utils.WsrfrpException;
import com.ebmwebsourcing.wsstar.wsnb.services.INotificationProducerRP;
import com.ebmwebsourcing.wsstar.wsrfbf.services.faults.AbsWSStarFault;
import javax.xml.namespace.QName;
import org.petalslink.dsb.soap.AbstractService;
import org.petalslink.dsb.soap.api.ServiceException;
import org.petalslink.dsb.soap.api.SimpleExchange;
import org.w3c.dom.Document;

public class NotificationProducerRPService
extends AbstractService {
    private INotificationProducerRP producerRP;

    public NotificationProducerRPService(QName interfaceName, QName serviceName, QName endpointName, String wsdl, String url, INotificationProducerRP producerRP) {
        super(interfaceName, serviceName, endpointName, wsdl, url);
        if (producerRP == null) {
            throw new IllegalArgumentException("Producer is null!");
        }
        this.producerRP = producerRP;
    }

    protected void doInvoke(SimpleExchange exchange) throws ServiceException {
        System.out.println("NotificationRP producer");
        System.out.println("org.petalslink.dsb.notification.service.NotificationProducerRPService");
        if (exchange == null || exchange.getIn() == null) {
            throw new ServiceException("Incoming message is null...");
        }
        QName operation = exchange.getOperation();
        if (operation == null) {
            throw new ServiceException("Incoming operation is null...");
        }
        if ("GetResourceProperty".equals(operation.getLocalPart())) {
            try {
                QName qname = RefinedWsrfrpFactory.getInstance().getWsrfrpReader().readGetResourceProperty(exchange.getIn());
                GetResourcePropertyResponse res = this.producerRP.getResourceProperty(qname);
                Document docResp = RefinedWsrfrpFactory.getInstance().getWsrfrpWriter().writeGetResourcePropertyResponseAsDOM(res);
                exchange.setOut(docResp);
            }
            catch (WsnbException e) {
                e.printStackTrace();
                throw new ServiceException((Throwable)e);
            }
            catch (AbsWSStarFault e) {
                e.printStackTrace();
                throw new ServiceException((Throwable)e);
            }
            catch (WsrfrpException e) {
                throw new ServiceException((Throwable)e);
            }
        } else if ("UpdateResourceProperties".equals(operation.getLocalPart())) {
            try {
                UpdateResourceProperties updateResourceProperties = RefinedWsrfrpFactory.getInstance().getWsrfrpReader().readUpdateResourceProperties(exchange.getIn());
                UpdateResourcePropertiesResponse res = this.producerRP.updateResourceProperties(updateResourceProperties);
                Document docResp = RefinedWsrfrpFactory.getInstance().getWsrfrpWriter().writeUpdateResourcePropertiesResponseAsDOM(res);
                exchange.setOut(docResp);
            }
            catch (WsnbException e) {
                throw new ServiceException((Throwable)e);
            }
            catch (AbsWSStarFault e) {
                throw new ServiceException((Throwable)e);
            }
            catch (WsrfrpException e) {
                throw new ServiceException((Throwable)e);
            }
        } else {
            throw new ServiceException("Unknown operation '" + operation + "'");
        }
    }
}

