/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.dsb.service.poller;

import java.text.ParseException;
import java.util.Date;
import java.util.UUID;
import org.petalslink.dsb.service.poller.AbstractPollerServiceImpl;
import org.petalslink.dsb.service.poller.ServiceCallJob;
import org.petalslink.dsb.service.poller.api.PollerException;
import org.petalslink.dsb.service.poller.api.PollingContext;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.TriggerBuilder;

public class QuartzPollerServiceImpl
extends AbstractPollerServiceImpl {
    private Scheduler sched;
    private String jobId;
    private JobDetail job;
    CronTrigger trigger;

    public QuartzPollerServiceImpl(PollingContext context, Scheduler scheduler) throws PollerException {
        super(context);
        this.sched = scheduler;
        this.jobId = UUID.randomUUID().toString();
        try {
            this.job = JobBuilder.newJob(ServiceCallJob.class).withIdentity(this.jobId, "group1").build();
            JobDataMap map = this.job.getJobDataMap();
            map.put((Object)"polling-context", context);
            this.trigger = TriggerBuilder.newTrigger().withIdentity("trigger4job-" + this.jobId, "group1").withSchedule(CronScheduleBuilder.cronSchedule(context.getCron())).build();
        }
        catch (ParseException e) {
            throw new PollerException(e.getMessage());
        }
        catch (IllegalArgumentException e) {
            throw new PollerException(e.getMessage());
        }
    }

    public void start() throws PollerException {
        try {
            Date ft = this.sched.scheduleJob(this.job, this.trigger);
            this.logger.info("JOB " + this.job.getKey() + " has been scheduled to run at: " + ft + " and repeat based on expression: " + this.trigger.getCronExpression());
        }
        catch (SchedulerException e) {
            throw new PollerException(e.getMessage());
        }
    }

    public void stop() throws PollerException {
        try {
            this.sched.deleteJob(this.job.getKey());
        }
        catch (SchedulerException e) {
            throw new PollerException(e.getMessage());
        }
    }

    public void pause() throws PollerException {
        if (this.job != null) {
            try {
                this.sched.pauseJob(this.job.getKey());
                this.logger.info("Job has been paused");
            }
            catch (SchedulerException e) {
                throw new PollerException(e.getMessage());
            }
        }
    }

    public void resume() throws PollerException {
        if (this.job != null) {
            try {
                this.sched.resumeJob(this.job.getKey());
                this.logger.info("Job has been resumed");
            }
            catch (SchedulerException e) {
                throw new PollerException(e.getMessage());
            }
        }
    }

    public String getId() {
        return this.jobId;
    }
}

