/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.dsb.soap;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Resource;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.ws.Provider;
import javax.xml.ws.Service;
import javax.xml.ws.ServiceMode;
import javax.xml.ws.WebServiceContext;
import javax.xml.ws.WebServiceProvider;
import org.petalslink.dsb.saaj.utils.SOAPMessageUtils;
import org.petalslink.dsb.soap.Exchange;
import org.petalslink.dsb.soap.api.Service;
import org.petalslink.dsb.soap.api.ServiceException;
import org.petalslink.dsb.soap.api.SimpleExchange;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@WebServiceProvider
@ServiceMode(value=Service.Mode.MESSAGE)
public class ServiceWrapper
implements Provider<SOAPMessage> {
    @Resource
    WebServiceContext wsContext;
    private Service service;
    private static Logger logger = Logger.getLogger(ServiceWrapper.class.getName());

    public ServiceWrapper(Service service) {
        this.service = service;
    }

    public SOAPMessage invoke(SOAPMessage request) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Invoking a service from request");
            logger.fine("PAYLOAD is " + SOAPMessageUtils.getSOAPMessageAsString((SOAPMessage)request));
        }
        Exchange exchange = new Exchange();
        try {
            exchange.setIn(this.getIn(request));
        }
        catch (SOAPException e1) {
            return null;
        }
        exchange.setOperation(this.getOperation());
        try {
            this.service.invoke(exchange);
        }
        catch (ServiceException e) {
            e.printStackTrace();
        }
        try {
            return this.createResponse(exchange);
        }
        catch (SOAPException e) {
            return null;
        }
    }

    private QName getOperation() {
        QName result = null;
        if (this.wsContext != null && this.wsContext.getMessageContext() != null) {
            Object o = this.wsContext.getMessageContext().get((Object)"javax.xml.ws.wsdl.operation");
            if (o != null && o instanceof QName) {
                result = (QName)o;
            }
            if (result != null && result.getLocalPart().equals("invoke") && result.getNamespaceURI().equals("http://cxf.apache.org/jaxws/provider") && this.wsContext.getMessageContext().get((Object)"SOAPAction") != null) {
                String soapAction = this.wsContext.getMessageContext().get((Object)"SOAPAction").toString();
                String ns = soapAction.substring(0, soapAction.lastIndexOf("/"));
                String localPart = soapAction.substring(soapAction.lastIndexOf("/") + 1);
                result = new QName(ns, localPart);
            }
        }
        return result;
    }

    private SOAPMessage createResponse(SimpleExchange exchange) throws SOAPException {
        SOAPMessage result = null;
        if (exchange.getFault() == null) {
            result = SOAPMessageUtils.createSOAPMessageFromBodyContent((Document)exchange.getOut());
        }
        return result;
    }

    private Document getIn(SOAPMessage request) throws SOAPException {
        return SOAPMessageUtils.getBodyFromMessage((SOAPMessage)request);
    }

    public Service getService() {
        return this.service;
    }
}

