/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.dsb.service.client;

import java.net.URI;
import javax.xml.namespace.QName;
import org.petalslink.dsb.service.client.MessageImpl;

public class WSAMessageImpl
extends MessageImpl {
    public static final String NAMESPACE_URI = "http://www.w3.org/2005/08/addressing";
    public static final String PREFIX = "wsa";
    public static final QName TO_QNAME = new QName("http://www.w3.org/2005/08/addressing", "To", "wsa");
    private String to;
    private String protocol;

    public WSAMessageImpl(String to) {
        this.to = to;
        try {
            URI uri = URI.create(to);
            this.protocol = uri.getScheme();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setProperty(TO_QNAME.toString(), this.to);
    }

    public String getEndpoint() {
        return "WSAEndpoint";
    }

    public QName getInterface() {
        return new QName(String.format("http://petals.ow2.org/wsa/%s/", this.protocol), "WSAInterface");
    }

    public QName getService() {
        return new QName(String.format("http://petals.ow2.org/wsa/%s/", this.protocol), "WSAService");
    }
}

