/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easybox.impl;

import com.ebmwebsourcing.easybox.api.ModelObject;
import com.ebmwebsourcing.easybox.api.XmlObject;
import com.ebmwebsourcing.easybox.api.XmlObjectReadException;
import com.ebmwebsourcing.easybox.api.XmlObjectReader;
import com.ebmwebsourcing.easybox.impl.AbstractJaxbModelObject;
import com.ebmwebsourcing.easybox.impl.AbstractJaxbXmlObjectImpl;
import com.ebmwebsourcing.easybox.impl.XmlContextImpl;
import com.ebmwebsourcing.easycommons.lang.UncheckedException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import javax.xml.bind.Binder;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

final class XmlObjectReaderImpl
implements XmlObjectReader {
    private static final DocumentBuilderFactory DOCUMENT_BUILDER_FACTORY = DocumentBuilderFactory.newInstance();
    private XmlContextImpl xmlContext;
    private XmlObjectReader.ReadMode readMode;
    private EntityResolver entityResolver;

    public XmlObjectReaderImpl(XmlContextImpl context) {
        this.xmlContext = context;
        this.readMode = XmlObjectReader.ReadMode.FULL;
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.entityResolver = entityResolver;
    }

    private DocumentBuilder createDocumentBuilder() {
        try {
            DocumentBuilder documentBuilder = DOCUMENT_BUILDER_FACTORY.newDocumentBuilder();
            if (this.entityResolver != null) {
                documentBuilder.setEntityResolver(this.entityResolver);
            }
            return documentBuilder;
        }
        catch (ParserConfigurationException e) {
            throw new UncheckedException("Cannot create DocumentBuilder (ParserConfigurationException).", (Throwable)e);
        }
    }

    public XmlObjectReader.ReadMode getReadMode() {
        return this.readMode;
    }

    public void setReadMode(XmlObjectReader.ReadMode readMode) {
        this.readMode = readMode;
    }

    private AbstractJaxbModelObject asAbstractJaxbObject(Object o) {
        AbstractJaxbModelObject ajo = null;
        if (o instanceof JAXBElement) {
            ajo = (AbstractJaxbModelObject)((JAXBElement)o).getValue();
        } else {
            if (!(o instanceof ModelObject)) {
                throw new UncheckedException("Object is not a model object!");
            }
            ajo = (AbstractJaxbModelObject)o;
        }
        return ajo;
    }

    private void finalizeReading(XmlObject xmlObject, String baseURI) {
        if (baseURI != null) {
            ((AbstractJaxbXmlObjectImpl)xmlObject).setXmlObjectBaseURI(URI.create(baseURI));
        }
        if (XmlObjectReader.ReadMode.FULL.equals((Object)this.readMode)) {
            this.readFully(xmlObject);
        }
    }

    private void readFully(XmlObject xmlObject) {
        xmlObject.getXmlObjectDescendants();
    }

    public <X extends XmlObject> X readDocument(URL url, Class<X> xmlObjectInterfaceClass) throws XmlObjectReadException {
        try {
            X xmlObject = this.readDocument(url.openStream(), xmlObjectInterfaceClass, url.toString());
            return xmlObject;
        }
        catch (IOException ioe) {
            throw new XmlObjectReadException((Throwable)ioe);
        }
    }

    public <X extends XmlObject> X readDocument(InputStream inputStream, Class<X> xmlObjectInterfaceClass) throws XmlObjectReadException {
        return this.readDocument(inputStream, xmlObjectInterfaceClass, null);
    }

    public <X extends XmlObject> X readDocument(InputSource inputSource, Class<X> xmlObjectInterfaceClass) throws XmlObjectReadException {
        try {
            DocumentBuilder documentBuilder = this.createDocumentBuilder();
            Binder<Node> binder = this.newBinder();
            Object unmarshalled = binder.unmarshal((Object)documentBuilder.parse(inputSource));
            AbstractJaxbModelObject ajo = this.asAbstractJaxbObject(unmarshalled);
            ajo.setBinder(binder);
            XmlObject newXmlObject = (XmlObject)this.xmlContext.getXmlObjectFactory().wrap((Object)ajo);
            this.finalizeReading(newXmlObject, inputSource.getSystemId());
            return (X)newXmlObject;
        }
        catch (JAXBException je) {
            throw new XmlObjectReadException((Throwable)je);
        }
        catch (SAXException se) {
            throw new XmlObjectReadException((Throwable)se);
        }
        catch (IOException ioe) {
            throw new XmlObjectReadException((Throwable)ioe);
        }
    }

    private <X extends XmlObject> X readDocument(InputStream inputStream, Class<X> xmlObjectInterfaceClass, String systemId) throws XmlObjectReadException {
        InputSource inputSource = new InputSource(inputStream);
        inputSource.setSystemId(systemId);
        return this.readDocument(inputSource, xmlObjectInterfaceClass);
    }

    public <X extends XmlObject> X readFragment(URL url, Class<X> xmlObjectInterfaceClass) throws XmlObjectReadException {
        try {
            X xmlObject = this.readFragment(url.openStream(), xmlObjectInterfaceClass, url.toString());
            return xmlObject;
        }
        catch (IOException ioe) {
            throw new XmlObjectReadException((Throwable)ioe);
        }
    }

    public <X extends XmlObject> X readFragment(InputStream inputStream, Class<X> xmlObjectInterfaceClass) throws XmlObjectReadException {
        return this.readFragment(inputStream, xmlObjectInterfaceClass, null);
    }

    public <X extends XmlObject> X readFragment(InputSource inputSource, Class<X> xmlObjectInterfaceClass) throws XmlObjectReadException {
        try {
            DocumentBuilder documentBuilder = this.createDocumentBuilder();
            AbstractJaxbXmlObjectImpl newXmlObject = (AbstractJaxbXmlObjectImpl)this.xmlContext.getXmlObjectFactory().create(xmlObjectInterfaceClass);
            Class<?> modelClass = ((AbstractJaxbModelObject)newXmlObject.getModelObject()).getClass();
            Binder<Node> binder = this.newBinder();
            JAXBElement unmarshalled = binder.unmarshal((Object)documentBuilder.parse(inputSource), modelClass);
            AbstractJaxbModelObject jaxbModelObject = this.asAbstractJaxbObject(unmarshalled);
            jaxbModelObject.setBinder(binder);
            newXmlObject.setModelObject(jaxbModelObject);
            this.finalizeReading(newXmlObject, inputSource.getSystemId());
            return (X)((XmlObject)xmlObjectInterfaceClass.cast(newXmlObject));
        }
        catch (JAXBException je) {
            throw new XmlObjectReadException((Throwable)je);
        }
        catch (SAXException se) {
            throw new XmlObjectReadException((Throwable)se);
        }
        catch (IOException ioe) {
            throw new XmlObjectReadException((Throwable)ioe);
        }
    }

    private <X extends XmlObject> X readFragment(InputStream inputStream, Class<X> xmlObjectInterfaceClass, String systemId) throws XmlObjectReadException {
        InputSource inputSource = new InputSource(inputStream);
        inputSource.setSystemId(systemId);
        return this.readFragment(inputSource, xmlObjectInterfaceClass);
    }

    private Binder<Node> newBinder() {
        return this.xmlContext.newBinder();
    }

    public <X extends XmlObject> X readDocument(Document document, Class<X> xmlObjectInterfaceClass) throws XmlObjectReadException {
        try {
            Binder<Node> binder = this.newBinder();
            Object unmarshalled = binder.unmarshal((Object)document);
            AbstractJaxbModelObject jaxbModelObject = this.asAbstractJaxbObject(unmarshalled);
            jaxbModelObject.setBinder(binder);
            XmlObject newXmlObject = (XmlObject)this.xmlContext.getXmlObjectFactory().wrap((Object)jaxbModelObject);
            this.finalizeReading(newXmlObject, document.getBaseURI());
            return (X)((XmlObject)xmlObjectInterfaceClass.cast(newXmlObject));
        }
        catch (JAXBException je) {
            throw new XmlObjectReadException((Throwable)je);
        }
    }

    public <X extends XmlObject> X readFragment(Document document, Class<X> xmlObjectInterfaceClass) throws XmlObjectReadException {
        try {
            AbstractJaxbXmlObjectImpl newXmlObject = (AbstractJaxbXmlObjectImpl)this.xmlContext.getXmlObjectFactory().create(xmlObjectInterfaceClass);
            Class<?> modelClass = ((AbstractJaxbModelObject)newXmlObject.getModelObject()).getClass();
            Binder<Node> binder = this.newBinder();
            JAXBElement unmarshalled = binder.unmarshal((Object)document, modelClass);
            AbstractJaxbModelObject jaxbModelObject = this.asAbstractJaxbObject(unmarshalled);
            jaxbModelObject.setBinder(binder);
            newXmlObject.setModelObject(jaxbModelObject);
            this.finalizeReading(newXmlObject, document.getBaseURI());
            return (X)((XmlObject)xmlObjectInterfaceClass.cast(newXmlObject));
        }
        catch (JAXBException je) {
            throw new XmlObjectReadException((Throwable)je);
        }
    }

    static {
        DOCUMENT_BUILDER_FACTORY.setNamespaceAware(true);
    }
}

