/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.dsb.jaxws;

import javax.jws.WebService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JAXWSHelper {
    public static final Class<?> getWebServiceClass(Class<?> cls) {
        if (cls == null) {
            return null;
        }
        if (null != cls.getAnnotation(WebService.class)) {
            return cls;
        }
        for (Class<?> inf : cls.getInterfaces()) {
            if (null == inf.getAnnotation(WebService.class)) continue;
            return inf;
        }
        return JAXWSHelper.getWebServiceClass(cls.getSuperclass());
    }

    public static final String getWebServiceName(Class<?> wsClass) {
        String serviceName = null;
        WebService anno = wsClass.getAnnotation(WebService.class);
        serviceName = anno.serviceName() == null || anno.serviceName().trim().length() == 0 ? wsClass.getSimpleName() : anno.serviceName();
        return serviceName;
    }

    public static boolean hasWebServiceAnnotation(Class<?> cls) {
        if (cls == null) {
            return false;
        }
        if (null != cls.getAnnotation(WebService.class)) {
            return true;
        }
        for (Class<?> inf : cls.getInterfaces()) {
            if (null == inf.getAnnotation(WebService.class)) continue;
            return true;
        }
        return JAXWSHelper.hasWebServiceAnnotation(cls.getSuperclass());
    }
}

