/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.dsb.api.util;

import javax.xml.namespace.QName;
import org.petalslink.dsb.api.ServiceEndpoint;

public class ResourceIdBuilder {
    public static String ROOT = "http://dsb.petalslink.org/endpoint/identifier";
    public static final String PATTERN = ROOT + "/%s/%s/%s/";

    private ResourceIdBuilder() {
    }

    public static final String getId(ServiceEndpoint serviceEndpoint) {
        String NS = String.format(PATTERN, serviceEndpoint.getComponentLocation(), serviceEndpoint.getSubdomainLocation(), serviceEndpoint.getContainerLocation());
        QName qname = new QName(NS, serviceEndpoint.getEndpointName());
        return qname.toString();
    }

    public static String getEndpointName(String id) {
        return QName.valueOf(id).getLocalPart();
    }

    public static String getComponent(String id) {
        String path = ResourceIdBuilder.getPath(id);
        return path.substring(0, path.indexOf("/"));
    }

    public static String getContainer(String id) {
        String path = ResourceIdBuilder.getPath(id);
        String subPath = path.substring(path.indexOf(47) + 1);
        String subsubPath = subPath.substring(subPath.indexOf(47) + 1);
        return subsubPath.substring(0, subsubPath.indexOf("/"));
    }

    public static String getDomain(String id) {
        String path = ResourceIdBuilder.getPath(id);
        String subPath = path.substring(path.indexOf(47) + 1);
        return subPath.substring(0, subPath.indexOf("/"));
    }

    private static String getPath(String id) {
        QName qname = QName.valueOf(id);
        if (qname.getNamespaceURI().startsWith(ROOT) && qname.getNamespaceURI().length() > ROOT.length() + 1) {
            return qname.getNamespaceURI().substring(ROOT.length() + 1);
        }
        return "";
    }
}

