/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.dsb.service.poller;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.petalslink.dsb.service.poller.api.Job;
import org.petalslink.dsb.service.poller.api.PollerException;
import org.petalslink.dsb.service.poller.api.PollingContext;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class ServiceCallJob
implements org.quartz.Job {
    public static final String POLLINGCONTEXT = "polling-context";
    public static final String COREJOB = "corejob";
    final Log logger = LogFactory.getLog(ServiceCallJob.class);

    public void execute(JobExecutionContext context) throws JobExecutionException {
        this.logger.info((Object)"It is time to call the service...");
        Object o = context.getJobDetail().getJobDataMap().get((Object)POLLINGCONTEXT);
        if (o == null) {
            this.logger.warn((Object)"Can not find the polling context in the job context...");
            throw new JobExecutionException("Can not find the polling context in the job context...");
        }
        PollingContext pollingContext = null;
        if (o == null || !(o instanceof PollingContext)) {
            throw new JobExecutionException("Bad polling context");
        }
        pollingContext = (PollingContext)o;
        Job coreJob = pollingContext.getJob();
        if (coreJob == null) {
            throw new JobExecutionException("Can not find any core job to call in the context");
        }
        try {
            coreJob.invoke(pollingContext);
        }
        catch (PollerException e) {
            throw new JobExecutionException("Some error occured during job invocation", (Throwable)e);
        }
    }
}

