/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.dsb.transport.cxf;

import java.util.ArrayList;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.jaxws.JaxWsServerFactoryBean;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.api.control.LifeCycleController;
import org.objectweb.fractal.fraclet.annotation.annotations.FractalComponent;
import org.objectweb.fractal.fraclet.annotation.annotations.Interface;
import org.objectweb.fractal.fraclet.annotation.annotations.LifeCycle;
import org.objectweb.fractal.fraclet.annotation.annotations.Provides;
import org.objectweb.fractal.fraclet.annotation.annotations.Requires;
import org.objectweb.fractal.fraclet.annotation.annotations.type.LifeCycleType;
import org.objectweb.util.monolog.api.Logger;
import org.objectweb.util.monolog.api.LoggerFactory;
import org.ow2.petals.kernel.configuration.ConfigurationService;
import org.ow2.petals.kernel.configuration.ContainerConfiguration;
import org.ow2.petals.util.LoggingUtil;
import org.petalslink.dsb.annotations.LifeCycleListener;
import org.petalslink.dsb.annotations.Phase;
import org.petalslink.dsb.transport.api.Receiver;
import org.petalslink.dsb.transport.cxf.TransportServiceImpl;

@FractalComponent
@Provides(interfaces={@Interface(name="service", signature=org.petalslink.dsb.transport.api.Server.class)})
public class CXFServerImpl
implements BindingController,
LifeCycleController,
org.petalslink.dsb.transport.api.Server {
    private Logger logger;
    private LoggingUtil log;
    private LoggerFactory loggerFactory;
    @Requires(name="receiver", signature=Receiver.class)
    private Receiver receiver;
    @Requires(name="configuration", signature=ConfigurationService.class)
    private ConfigurationService configuration;
    private Server server;

    public Logger getLogger() {
        return this.logger;
    }

    @LifeCycle(on=LifeCycleType.START)
    public void start() {
        this.log = new LoggingUtil(this.logger);
        this.log.debug((Object)"Starting...");
    }

    @LifeCycle(on=LifeCycleType.STOP)
    public void stop() {
        this.log.debug((Object)"Stopping...");
        this.stopServer();
    }

    public LoggerFactory getLoggerFactory() {
        return this.loggerFactory;
    }

    public String getFcState() {
        return null;
    }

    @LifeCycleListener(phase=Phase.START, priority=101)
    public void startServer() {
        JaxWsServerFactoryBean jaxWsServerFactoryBean = new JaxWsServerFactoryBean();
        TransportServiceImpl transportServiceImpl = new TransportServiceImpl(this.receiver, this.log);
        ContainerConfiguration containerConfiguration = this.configuration.getContainerConfiguration();
        String string = "http://" + containerConfiguration.getHost() + ":" + containerConfiguration.getWebservicePort() + "/petals/core/TransportService";
        jaxWsServerFactoryBean.setAddress(string);
        jaxWsServerFactoryBean.setServiceBean((Object)transportServiceImpl);
        this.server = jaxWsServerFactoryBean.create();
        this.log.info((Object)("The WebService transporter is ready to receive messages at " + string));
    }

    public void setLoggerFactory(LoggerFactory loggerFactory) {
        this.loggerFactory = loggerFactory;
        this.logger = this.getLoggerFactory().getLogger("logger");
    }

    public void startFc() throws IllegalLifeCycleException {
        try {
            this.start();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    public void stopServer() {
        if (this.server != null) {
            this.server.stop();
        }
    }

    public void stopFc() throws IllegalLifeCycleException {
        try {
            this.stop();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public void setLog(LoggingUtil loggingUtil) {
        this.log = loggingUtil;
    }

    public void setReceiver(Receiver receiver) {
        this.receiver = receiver;
    }

    public void setConfiguration(ConfigurationService configurationService) {
        this.configuration = configurationService;
    }

    public void bindFc(String string, Object object) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("logger")) {
            this.logger = (Logger)object;
            return;
        }
        if (string.equals("logger-factory")) {
            this.setLoggerFactory((LoggerFactory)object);
            return;
        }
        if (string.equals("receiver")) {
            if (!Receiver.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + Receiver.class.getName());
            }
            this.receiver = (Receiver)object;
            return;
        }
        if (string.equals("configuration")) {
            if (!ConfigurationService.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + ConfigurationService.class.getName());
            }
            this.configuration = (ConfigurationService)object;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public String[] listFc() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("receiver");
        arrayList.add("configuration");
        return arrayList.toArray(new String[0]);
    }

    public Object lookupFc(String string) throws NoSuchInterfaceException {
        if (string.equals("receiver")) {
            return this.receiver;
        }
        if (string.equals("configuration")) {
            return this.configuration;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public void unbindFc(String string) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("receiver")) {
            this.receiver = null;
            return;
        }
        if (string.equals("configuration")) {
            this.configuration = null;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }
}

