/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.dsb.transport.cxf;

import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.cxf.jaxws.JaxWsProxyFactoryBean;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.api.control.LifeCycleController;
import org.objectweb.fractal.fraclet.annotation.annotations.FractalComponent;
import org.objectweb.fractal.fraclet.annotation.annotations.Interface;
import org.objectweb.fractal.fraclet.annotation.annotations.LifeCycle;
import org.objectweb.fractal.fraclet.annotation.annotations.Provides;
import org.objectweb.fractal.fraclet.annotation.annotations.Requires;
import org.objectweb.fractal.fraclet.annotation.annotations.type.LifeCycleType;
import org.objectweb.util.monolog.api.Logger;
import org.objectweb.util.monolog.api.LoggerFactory;
import org.ow2.petals.kernel.configuration.ConfigurationService;
import org.ow2.petals.kernel.configuration.ContainerConfiguration;
import org.ow2.petals.util.oldies.LoggingUtil;
import org.petalslink.dsb.api.TransportService;
import org.petalslink.dsb.transport.api.Client;
import org.petalslink.dsb.transport.api.ClientFactory;
import org.petalslink.dsb.transport.cxf.CXFClientImpl;

@FractalComponent
@Provides(interfaces={@Interface(name="service", signature=ClientFactory.class)})
public class CXFClientFactory
implements BindingController,
LifeCycleController,
ClientFactory {
    private Map<String, Client> cache;
    private Logger logger;
    private LoggerFactory loggerFactory;
    private LoggingUtil log;
    @Requires(name="configuration", signature=ConfigurationService.class)
    private ConfigurationService configurationService;

    @LifeCycle(on=LifeCycleType.START)
    public void start() {
        this.log = new LoggingUtil(this.logger);
        this.log.debug((Object)"Starting...");
        this.cache = new ConcurrentHashMap<String, Client>();
    }

    public Logger getLogger() {
        return this.logger;
    }

    @LifeCycle(on=LifeCycleType.STOP)
    public void stop() {
        this.log.debug((Object)"Stopping...");
    }

    public synchronized Client getClient(String string) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Getting a transport client for container '" + string + "'"));
        }
        Client client = null;
        if (this.cache.get(string) == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Creating a new transport client for container '" + string + "'"));
            }
            ContainerConfiguration containerConfiguration = this.configurationService.getContainerConfiguration(string);
            String string2 = "http://" + containerConfiguration.getHost() + ":" + containerConfiguration.getWebservicePort() + "/petals/core/TransportService";
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Creating a CXF client to reach container " + string + " located at " + string2));
            }
            JaxWsProxyFactoryBean jaxWsProxyFactoryBean = new JaxWsProxyFactoryBean();
            jaxWsProxyFactoryBean.setAddress(string2);
            jaxWsProxyFactoryBean.setServiceClass(TransportService.class);
            TransportService transportService = (TransportService)jaxWsProxyFactoryBean.create();
            client = new CXFClientImpl(transportService, this.log);
            this.cache.put(string, client);
        } else {
            client = this.cache.get(string);
        }
        return client;
    }

    public LoggerFactory getLoggerFactory() {
        return this.loggerFactory;
    }

    public String getFcState() {
        return null;
    }

    public void setLoggerFactory(LoggerFactory loggerFactory) {
        this.loggerFactory = loggerFactory;
        this.logger = this.getLoggerFactory().getLogger("logger");
    }

    public void startFc() throws IllegalLifeCycleException {
        try {
            this.start();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    public void stopFc() throws IllegalLifeCycleException {
        try {
            this.stop();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    public void releaseClient(String string, Client client) {
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public void setLog(LoggingUtil loggingUtil) {
        this.log = loggingUtil;
    }

    public void setConfigurationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

    public void bindFc(String string, Object object) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("logger")) {
            this.logger = (Logger)object;
            return;
        }
        if (string.equals("logger-factory")) {
            this.setLoggerFactory((LoggerFactory)object);
            return;
        }
        if (string.equals("configuration")) {
            if (!ConfigurationService.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + ConfigurationService.class.getName());
            }
            this.configurationService = (ConfigurationService)object;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public String[] listFc() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("configuration");
        return arrayList.toArray(new String[0]);
    }

    public Object lookupFc(String string) throws NoSuchInterfaceException {
        if (string.equals("configuration")) {
            return this.configurationService;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public void unbindFc(String string) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("configuration")) {
            this.configurationService = null;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }
}

