/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.dsb.transport.cxf;

import org.apache.cxf.endpoint.Client;
import org.apache.cxf.frontend.ClientProxy;
import org.apache.cxf.transport.http.HTTPConduit;
import org.apache.cxf.transports.http.configuration.HTTPClientPolicy;
import org.ow2.petals.jbi.messaging.exchange.MessageExchangeWrapper;
import org.ow2.petals.util.oldies.LoggingUtil;
import org.petalslink.dsb.api.MessageExchange;
import org.petalslink.dsb.api.TransportException;
import org.petalslink.dsb.api.TransportService;
import org.petalslink.dsb.transport.Adapter;
import org.petalslink.dsb.transport.api.ClientException;

public class CXFClientImpl
implements org.petalslink.dsb.transport.api.Client {
    private final TransportService transportService;
    private final LoggingUtil log;

    public CXFClientImpl(TransportService transportService, LoggingUtil loggingUtil) {
        this.transportService = transportService;
        this.log = loggingUtil;
    }

    public void send(MessageExchangeWrapper messageExchangeWrapper, long l) throws ClientException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Sending message exchange...");
        }
        this.setTimeout(l);
        MessageExchange messageExchange = Adapter.createWSMessage((MessageExchangeWrapper)messageExchangeWrapper);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Sending the following message : " + messageExchange.toString()));
        }
        try {
            this.transportService.receive(messageExchange);
        }
        catch (TransportException transportException) {
            String string = "Got an error : " + transportException.getMessage();
            if (this.log.isDebugEnabled()) {
                this.log.warning((Object)string, (Throwable)transportException);
            } else {
                this.log.warning((Object)string);
            }
            throw new ClientException(transportException.getMessage());
        }
    }

    private void setTimeout(long l) {
        Client client = ClientProxy.getClient((Object)this.transportService);
        if (client != null) {
            HTTPConduit hTTPConduit = (HTTPConduit)client.getConduit();
            HTTPClientPolicy hTTPClientPolicy = new HTTPClientPolicy();
            hTTPClientPolicy.setConnectionTimeout(l);
            hTTPClientPolicy.setReceiveTimeout(l);
            hTTPConduit.setClient(hTTPClientPolicy);
        }
    }
}

