/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.dsb.transport;

import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import org.petalslink.dsb.api.MessageExchange;
import org.petalslink.dsb.api.TransportException;
import org.petalslink.dsb.transport.TransporterUtils;
import org.petalslink.dsb.transport.api.Client;
import org.petalslink.dsb.transport.api.ClientException;
import org.petalslink.dsb.transport.api.ClientFactory;
import org.petalslink.dsb.transport.api.Constants;
import org.petalslink.dsb.transport.api.Context;
import org.petalslink.dsb.transport.api.ReceiveInterceptor;
import org.petalslink.dsb.transport.api.Receiver;
import org.petalslink.dsb.transport.api.SendInterceptor;
import org.petalslink.dsb.transport.api.Server;
import org.petalslink.dsb.transport.api.Transporter;

public class TransporterImpl
implements Transporter {
    private static Logger log = Logger.getLogger(TransporterImpl.class.getName());
    private Map<String, MessageExchange> pendingSyncExchanges;
    private boolean stopTraffic;
    private Receiver transportListener;
    private ClientFactory clientFactory;
    private SendInterceptor sendInterceptor;
    private ReceiveInterceptor receiveInterceptor;
    private Server server;

    public void start() {
        this.pendingSyncExchanges = new ConcurrentHashMap<String, MessageExchange>(100);
        if (this.server != null) {
            this.server.start();
        }
    }

    public void stop() {
        if (this.server != null) {
            this.server.stop();
        }
    }

    public void send(MessageExchange exchange, Context context) throws TransportException {
        if (exchange == null) {
            throw new TransportException("Can not send a null message");
        }
        if (this.clientFactory == null) {
            throw new TransportException("Can not find any Client factory, check configuration");
        }
        boolean intercept = this.interceptSend(exchange, context);
        if (!intercept) {
            return;
        }
        this.checkTransporterState();
        try {
            Client client = this.clientFactory.getClient(context);
            if (client == null) {
                throw new TransportException("Can not find a client to reach remote container");
            }
            try {
                client.send(exchange, context.timeout);
            }
            finally {
                this.clientFactory.releaseClient(context, client);
            }
        }
        catch (Exception e) {
            throw new TransportException((Throwable)e);
        }
    }

    private boolean interceptSend(MessageExchange exchange, Context transportContext) {
        boolean result = true;
        if (this.sendInterceptor == null) {
            return true;
        }
        try {
            Constants.STATUS status = this.sendInterceptor.send(exchange, transportContext);
            result = status == Constants.STATUS.CONTINUE;
        }
        catch (ClientException e) {
            e.printStackTrace();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageExchange sendSync(MessageExchange exchange, Context transportContext) throws TransportException {
        if (exchange == null) {
            throw new TransportException("Can not send a null message");
        }
        if (this.clientFactory == null) {
            throw new TransportException("Can not find any Client factory, check configuration");
        }
        MessageExchange responseExchange = null;
        this.checkTransporterState();
        this.setSynchronous(exchange, true);
        this.pendingSyncExchanges.put(exchange.getId(), exchange);
        try {
            MessageExchange messageExchange = exchange;
            synchronized (messageExchange) {
                this.send(exchange, transportContext);
                exchange.wait(transportContext.timeout);
            }
            responseExchange = this.pendingSyncExchanges.remove(exchange.getId());
        }
        catch (InterruptedException e) {
            this.pendingSyncExchanges.remove(exchange);
            throw new TransportException("Failed to receive the response message of a synchronous send", (Throwable)e);
        }
        if (responseExchange == exchange) {
            this.checkTransporterState();
            return null;
        }
        return responseExchange;
    }

    protected void setSynchronous(MessageExchange exchange, boolean sync) {
        TransporterUtils.setProperty(exchange, Constants.SYNC, Boolean.toString(sync));
    }

    protected boolean isSynchronous(MessageExchange exchange) {
        String value = TransporterUtils.getPropertyValue(exchange, Constants.SYNC);
        return Boolean.parseBoolean(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopTraffic() {
        this.stopTraffic = true;
        boolean redo = true;
        while (redo) {
            try {
                Iterator<MessageExchange> iterator = this.pendingSyncExchanges.values().iterator();
                while (iterator.hasNext()) {
                    MessageExchange messageExchange;
                    MessageExchange messageExchange2 = messageExchange = iterator.next();
                    synchronized (messageExchange2) {
                        messageExchange.notify();
                    }
                }
                redo = false;
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                // empty catch block
            }
        }
    }

    private void checkTransporterState() throws TransportException {
        if (this.stopTraffic) {
            Thread.currentThread().interrupt();
            throw new TransportException("The Transporter traffic is stopped", (Throwable)new InterruptedException());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(MessageExchange messageExchange) {
        boolean intercept = this.interceptReceive(messageExchange);
        if (!intercept) {
            return;
        }
        boolean sync = this.isSynchronous(messageExchange);
        if (sync) {
            MessageExchange exchange;
            MessageExchange messageExchange2 = exchange = this.pendingSyncExchanges.put(messageExchange.getId(), messageExchange);
            synchronized (messageExchange2) {
                exchange.notify();
            }
        } else if (this.transportListener != null) {
            this.transportListener.onMessage(messageExchange);
        }
    }

    private boolean interceptReceive(MessageExchange messageExchange) {
        boolean result = true;
        if (this.receiveInterceptor == null) {
            return true;
        }
        Constants.STATUS status = this.receiveInterceptor.receive(messageExchange);
        result = status == Constants.STATUS.CONTINUE;
        return result;
    }

    public void setTransportListener(Receiver transportListener) {
        this.transportListener = transportListener;
    }

    public void setClientFactory(ClientFactory clientFactory) {
        this.clientFactory = clientFactory;
    }

    public void setSendInterceptor(SendInterceptor sendInterceptor) {
        this.sendInterceptor = sendInterceptor;
    }

    public void setReceiveInterceptor(ReceiveInterceptor receiveInterceptor) {
        this.receiveInterceptor = receiveInterceptor;
    }

    public void sendAsync(MessageExchange exchange, Context context, Receiver listener) throws TransportException {
        throw new TransportException("Not implemented");
    }

    public void setServer(Server server) {
        this.server = server;
    }
}

