/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.dsb.transport.soap;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.petalslink.dsb.api.TransportService;
import org.petalslink.dsb.cxf.CXFHelper;
import org.petalslink.dsb.transport.api.Client;
import org.petalslink.dsb.transport.api.ClientFactory;
import org.petalslink.dsb.transport.api.Context;
import org.petalslink.dsb.transport.soap.CXFClientImpl;

public class CXFClientFactory
implements ClientFactory {
    private static Logger log = Logger.getLogger(CXFClientFactory.class.getName());
    private Map<String, Client> cache = new ConcurrentHashMap<String, Client>();

    public void start() {
    }

    public void stop() {
    }

    public synchronized Client getClient(Context context) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Getting a transport client for container '" + context + "'");
        }
        String cfr_ignored_0 = context.containerName;
        Client client = null;
        if (this.cache.get(context.containerName) == null) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("Creating a new transport client for container '" + context + "'");
            }
            String address = "http://" + context.hostName + ":" + context.port + "/petals/core/TransportService";
            if (log.isLoggable(Level.FINE)) {
                log.fine("Creating a CXF client to reach container " + context + " located at " + address);
            }
            String baseURL = "http://" + context.hostName + ":" + context.port;
            TransportService transportServiceClient = (TransportService)CXFHelper.getClient((String)baseURL, TransportService.class);
            client = new CXFClientImpl(transportServiceClient);
            this.cache.put(context.containerName, client);
        } else {
            client = this.cache.get(context.containerName);
        }
        return client;
    }

    public void releaseClient(Context context, Client client) {
    }
}

