/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.dsb.transport.soap;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.frontend.ClientProxy;
import org.apache.cxf.transport.http.HTTPConduit;
import org.apache.cxf.transports.http.configuration.HTTPClientPolicy;
import org.petalslink.dsb.api.MessageExchange;
import org.petalslink.dsb.api.TransportException;
import org.petalslink.dsb.api.TransportService;
import org.petalslink.dsb.transport.api.ClientException;

public class CXFClientImpl
implements org.petalslink.dsb.transport.api.Client {
    private final TransportService transportService;
    private static Logger log = Logger.getLogger(CXFClientImpl.class.getName());

    public CXFClientImpl(TransportService transportService) {
        this.transportService = transportService;
    }

    public void send(MessageExchange exchange, long sendTimeout) throws ClientException {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Sending message exchange...");
        }
        this.setTimeout(sendTimeout);
        if (log.isLoggable(Level.FINE)) {
            log.fine("Sending the following message : " + exchange);
        }
        try {
            this.transportService.receive(exchange);
        }
        catch (TransportException e) {
            String error = "Got an error : " + e.getMessage();
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.WARNING, error, e);
            } else {
                log.warning(error);
            }
            throw new ClientException(e.getMessage());
        }
    }

    private void setTimeout(long timeout) {
        Client cxf = ClientProxy.getClient((Object)this.transportService);
        if (cxf != null) {
            HTTPConduit conduit = (HTTPConduit)cxf.getConduit();
            HTTPClientPolicy policy = new HTTPClientPolicy();
            policy.setConnectionTimeout(timeout);
            policy.setReceiveTimeout(timeout);
            conduit.setClient(policy);
        }
    }
}

