/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.dsb.transport.soap;

import java.util.logging.Logger;
import org.petalslink.dsb.api.TransportService;
import org.petalslink.dsb.commons.service.api.Service;
import org.petalslink.dsb.cxf.CXFHelper;
import org.petalslink.dsb.transport.api.Receiver;
import org.petalslink.dsb.transport.api.Server;
import org.petalslink.dsb.transport.soap.TransportServiceImpl;

public class CXFServerImpl
implements Server {
    private static Logger log = Logger.getLogger(CXFServerImpl.class.getName());
    private Receiver receiver;
    private Service server;
    private String host;
    private long port;

    public CXFServerImpl(String host, long port) {
        this.host = host;
        this.port = port;
    }

    public void start() {
        TransportServiceImpl service = new TransportServiceImpl(this.receiver);
        String address = "http://" + this.host + ":" + this.port;
        this.server = CXFHelper.getService((String)address, TransportService.class, (Object)service);
        this.server.start();
        log.info("The WebService transporter is ready to receive messages at " + address);
    }

    public void stop() {
        if (this.server != null) {
            this.server.stop();
        }
    }

    public void setReceiver(Receiver receiver) {
        this.receiver = receiver;
    }
}

