/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.dsb.transport.soap;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.petalslink.dsb.api.MessageExchange;
import org.petalslink.dsb.api.TransportException;
import org.petalslink.dsb.api.TransportService;
import org.petalslink.dsb.transport.api.Receiver;
import org.petalslink.dsb.transport.soap.CXFServerImpl;

public class TransportServiceImpl
implements TransportService {
    private final Receiver receiver;
    private static Logger log = Logger.getLogger(CXFServerImpl.class.getName());

    public TransportServiceImpl(Receiver receiver) {
        this.receiver = receiver;
    }

    public void receive(MessageExchange messageExchange) throws TransportException {
        if (messageExchange == null) {
            String message = "Null message received!!!";
            log.warning("Null message received!!!");
            throw new TransportException("Null message received!!!");
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("Receiving a message " + messageExchange.getId());
            log.fine(messageExchange.toString());
        }
        if (this.receiver == null) {
            log.warning("There is no receiver on this transporter...");
        } else {
            this.receiver.onMessage(messageExchange);
        }
    }
}

