/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.dsb.transport.xmpp;

import java.util.HashMap;
import java.util.Map;
import org.jivesoftware.smack.Chat;
import org.jivesoftware.smack.ConnectionConfiguration;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.MessageTypeFilter;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.Presence;
import org.petalslink.dsb.transport.xmpp.XMPPChatMessageListener;

public class XMPPConnectionManager {
    public static int AVAILABLE_STATUS = 1;
    public static int UNAVAILABLE_STATUS = 2;
    private static Map<Integer, Presence> PRESENCE = new HashMap<Integer, Presence>();
    private static XMPPConnectionManager SINGLETON;
    private XMPPConnection connection;

    static {
        PRESENCE.put(AVAILABLE_STATUS, new Presence(Presence.Type.available));
        PRESENCE.put(UNAVAILABLE_STATUS, new Presence(Presence.Type.unavailable));
    }

    public static synchronized XMPPConnectionManager getInstance() {
        if (SINGLETON == null) {
            SINGLETON = new XMPPConnectionManager();
        }
        return SINGLETON;
    }

    private XMPPConnectionManager() {
    }

    public boolean connect() {
        boolean bl = true;
        if (this.connection != null) {
            return bl;
        }
        ConnectionConfiguration connectionConfiguration = new ConnectionConfiguration("talk.google.com", 5222, "gmail.com");
        this.connection = new XMPPConnection(connectionConfiguration);
        try {
            this.connection.connect();
        }
        catch (XMPPException xMPPException) {
            xMPPException.printStackTrace();
            bl = false;
        }
        return bl;
    }

    public void login(String string, String string2) {
        if (this.connection != null) {
            try {
                this.connection.login(string, string2);
            }
            catch (XMPPException xMPPException) {
                xMPPException.printStackTrace();
            }
        }
    }

    public void disconnect() {
        if (this.connection != null) {
            this.connection.disconnect();
        }
    }

    public void send(Message message, String string) {
        Chat chat = this.connection.getChatManager().createChat(string, null);
        try {
            chat.sendMessage(message);
        }
        catch (XMPPException xMPPException) {
            xMPPException.printStackTrace();
        }
    }

    public XMPPConnection getConnection() {
        return this.connection;
    }

    public void setStatus(int n, String string) {
        if (this.connection != null && this.connection.isConnected() && PRESENCE.get(n) != null) {
            Presence presence = PRESENCE.get(n);
            presence.setStatus(string);
            this.getConnection().sendPacket((Packet)PRESENCE.get(n));
        }
    }

    public void addPacketListener(XMPPChatMessageListener xMPPChatMessageListener, MessageTypeFilter messageTypeFilter) {
        if (this.connection != null) {
            this.getConnection().addPacketListener((PacketListener)xMPPChatMessageListener, (PacketFilter)messageTypeFilter);
        }
    }
}

