/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.dsb.transport.xmpp;

import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.jivesoftware.smack.RosterEntry;
import org.jivesoftware.smack.RosterListener;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.filter.MessageTypeFilter;
import org.jivesoftware.smack.packet.Message;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.api.control.LifeCycleController;
import org.objectweb.fractal.fraclet.annotation.annotations.FractalComponent;
import org.objectweb.fractal.fraclet.annotation.annotations.Interface;
import org.objectweb.fractal.fraclet.annotation.annotations.LifeCycle;
import org.objectweb.fractal.fraclet.annotation.annotations.Provides;
import org.objectweb.fractal.fraclet.annotation.annotations.Requires;
import org.objectweb.fractal.fraclet.annotation.annotations.type.LifeCycleType;
import org.objectweb.util.monolog.api.Logger;
import org.objectweb.util.monolog.api.LoggerFactory;
import org.ow2.petals.kernel.configuration.ConfigurationService;
import org.ow2.petals.util.LoggingUtil;
import org.petalslink.dsb.transport.api.Receiver;
import org.petalslink.dsb.transport.api.Server;
import org.petalslink.dsb.transport.xmpp.XMPPChatMessageListener;
import org.petalslink.dsb.transport.xmpp.XMPPConnectionManager;
import org.petalslink.dsb.transport.xmpp.XMPPRosterListener;

@FractalComponent
@Provides(interfaces={@Interface(name="service", signature=Server.class)})
public class XMPPServerImpl
implements BindingController,
LifeCycleController,
Server {
    private Logger logger;
    private LoggerFactory loggerFactory;
    private LoggingUtil log;
    @Requires(name="receiver", signature=Receiver.class)
    private Receiver receiver;
    @Requires(name="configuration", signature=ConfigurationService.class)
    private ConfigurationService configuration;
    private ExecutorService executorService;

    public Logger getLogger() {
        return this.logger;
    }

    @LifeCycle(on=LifeCycleType.START)
    protected void start() {
        this.log = new LoggingUtil(this.logger);
        this.log.debug((Object)"Starting...");
        this.executorService = Executors.newFixedThreadPool(5);
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    @LifeCycle(on=LifeCycleType.STOP)
    protected void stop() {
        this.log.debug((Object)"Stopping...");
        this.stopServer();
    }

    public LoggerFactory getLoggerFactory() {
        return this.loggerFactory;
    }

    public String getFcState() {
        return null;
    }

    public void startServer() {
        XMPPConnectionManager xMPPConnectionManager = XMPPConnectionManager.getInstance();
        boolean bl = xMPPConnectionManager.connect();
        if (bl) {
            this.log.info((Object)"Connected to Jabber server, let's login now...");
            String string = String.valueOf(this.configuration.getContainerConfiguration().getUser()) + "@gmail.com";
            String string2 = this.configuration.getContainerConfiguration().getPassword();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Login with user = '" + string + "' and password = '" + string2 + "'"));
            }
            xMPPConnectionManager.login(string, string2);
            xMPPConnectionManager.setStatus(XMPPConnectionManager.AVAILABLE_STATUS, "Petals ESB '" + this.configuration.getContainerConfiguration().getName() + "' ready to process messages!");
            xMPPConnectionManager.addPacketListener(new XMPPChatMessageListener(this.receiver, this.executorService, this.log), new MessageTypeFilter(Message.Type.chat));
            if (this.log.isDebugEnabled()) {
                this.displayContacts();
            }
            xMPPConnectionManager.getConnection().getRoster().addRosterListener((RosterListener)new XMPPRosterListener(this.log));
        } else {
            this.log.warning((Object)"Not connected to jabber server!!!");
        }
    }

    public void setLoggerFactory(LoggerFactory loggerFactory) {
        this.loggerFactory = loggerFactory;
        this.logger = this.getLoggerFactory().getLogger("logger");
    }

    public void startFc() throws IllegalLifeCycleException {
        try {
            this.start();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    public void stopFc() throws IllegalLifeCycleException {
        try {
            this.stop();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    private void displayContacts() {
        XMPPConnection xMPPConnection = XMPPConnectionManager.getInstance().getConnection();
        if (xMPPConnection != null && xMPPConnection.isConnected()) {
            for (RosterEntry rosterEntry : xMPPConnection.getRoster().getEntries()) {
                this.log.info((Object)("Available contact : Name = " + rosterEntry.getName() + " , User = " + rosterEntry.getUser() + " , Status = " + rosterEntry.getStatus()));
            }
        }
    }

    public void stopServer() {
        if (this.executorService != null) {
            this.executorService.shutdownNow();
        }
        XMPPConnectionManager.getInstance().setStatus(XMPPConnectionManager.UNAVAILABLE_STATUS, "Bye bye!!!");
        XMPPConnectionManager.getInstance().disconnect();
    }

    public void bindFc(String string, Object object) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("logger")) {
            this.logger = (Logger)object;
            return;
        }
        if (string.equals("logger-factory")) {
            this.setLoggerFactory((LoggerFactory)object);
            return;
        }
        if (string.equals("receiver")) {
            if (!Receiver.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + Receiver.class.getName());
            }
            this.receiver = (Receiver)object;
            return;
        }
        if (string.equals("configuration")) {
            if (!ConfigurationService.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + ConfigurationService.class.getName());
            }
            this.configuration = (ConfigurationService)object;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public String[] listFc() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("receiver");
        arrayList.add("configuration");
        return arrayList.toArray(new String[0]);
    }

    public Object lookupFc(String string) throws NoSuchInterfaceException {
        if (string.equals("receiver")) {
            return this.receiver;
        }
        if (string.equals("configuration")) {
            return this.configuration;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public void unbindFc(String string) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("receiver")) {
            this.receiver = null;
            return;
        }
        if (string.equals("configuration")) {
            this.configuration = null;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }
}

