/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.dsb.transport.xmpp;

import java.util.concurrent.ExecutorService;
import javax.jbi.messaging.MessagingException;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Packet;
import org.ow2.petals.jbi.messaging.exchange.MessageExchangeWrapper;
import org.ow2.petals.util.oldies.LoggingUtil;
import org.petalslink.dsb.transport.api.Receiver;
import org.petalslink.dsb.transport.xmpp.Adapter;

public class XMPPChatMessageListener
implements PacketListener {
    private final Receiver receiver;
    private final LoggingUtil log;
    private final ExecutorService executorService;

    public XMPPChatMessageListener(Receiver receiver, ExecutorService executorService, LoggingUtil loggingUtil) {
        this.receiver = receiver;
        this.executorService = executorService;
        this.log = loggingUtil;
    }

    public void processPacket(Packet packet) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Just got an XMPP packet from '" + packet.getFrom() + "' : " + packet.toXML()));
        }
        if (packet instanceof Message) {
            this.executorService.submit(new Worker((Message)packet));
        } else {
            this.log.warning((Object)"Not a valid packet, we just process messages");
        }
    }

    class Worker
    implements Runnable {
        private final Message message;

        public Worker(Message message) {
            this.message = message;
        }

        public void run() {
            try {
                MessageExchangeWrapper messageExchangeWrapper = Adapter.createJBIMessage(this.message);
                if (messageExchangeWrapper != null) {
                    XMPPChatMessageListener.this.receiver.onMessage(messageExchangeWrapper);
                } else {
                    XMPPChatMessageListener.this.log.warning((Object)"Incoming message body is null");
                }
            }
            catch (MessagingException messagingException) {
                XMPPChatMessageListener.this.log.warning((Object)"Processing packet error", (Throwable)messagingException);
            }
        }
    }
}

