/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.dsb.transport;

import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.api.control.LifeCycleController;
import org.objectweb.fractal.fraclet.annotation.annotations.FractalComponent;
import org.objectweb.fractal.fraclet.annotation.annotations.Interface;
import org.objectweb.fractal.fraclet.annotation.annotations.LifeCycle;
import org.objectweb.fractal.fraclet.annotation.annotations.Provides;
import org.objectweb.fractal.fraclet.annotation.annotations.Requires;
import org.objectweb.fractal.fraclet.annotation.annotations.type.Contingency;
import org.objectweb.fractal.fraclet.annotation.annotations.type.LifeCycleType;
import org.objectweb.util.monolog.api.Logger;
import org.objectweb.util.monolog.api.LoggerFactory;
import org.ow2.petals.jbi.messaging.exchange.MessageExchangeWrapper;
import org.ow2.petals.kernel.configuration.ConfigurationService;
import org.ow2.petals.transport.TransportException;
import org.ow2.petals.transport.TransportListener;
import org.ow2.petals.transport.Transporter;
import org.ow2.petals.transport.util.TransportSendContext;
import org.ow2.petals.transport.util.TransporterUtil;
import org.ow2.petals.util.oldies.LoggingUtil;
import org.petalslink.dsb.transport.api.Client;
import org.petalslink.dsb.transport.api.ClientException;
import org.petalslink.dsb.transport.api.ClientFactory;
import org.petalslink.dsb.transport.api.Constants;
import org.petalslink.dsb.transport.api.ReceiveInterceptor;
import org.petalslink.dsb.transport.api.Receiver;
import org.petalslink.dsb.transport.api.SendInterceptor;

@FractalComponent
@Provides(interfaces={@Interface(name="service", signature=Transporter.class), @Interface(name="receiver", signature=Receiver.class)})
public class TransporterImpl
implements BindingController,
LifeCycleController,
Transporter,
Receiver {
    private LoggerFactory loggerFactory;
    private Map<String, MessageExchangeWrapper> pendingSyncExchanges;
    private boolean stopTraffic;
    private Logger logger;
    private LoggingUtil log;
    @Requires(name="configuration", signature=ConfigurationService.class)
    private ConfigurationService configurationService;
    @Requires(name="transportlistener", signature=TransportListener.class)
    private TransportListener transportListener;
    @Requires(name="clientfactory", signature=ClientFactory.class)
    private ClientFactory clientFactory;
    @Requires(contingency=Contingency.OPTIONAL, name="sendinterceptor", signature=SendInterceptor.class)
    private SendInterceptor sendInterceptor;
    @Requires(contingency=Contingency.OPTIONAL, name="receiveinterceptor", signature=ReceiveInterceptor.class)
    private ReceiveInterceptor receiveInterceptor;
    private long sendTimeout;

    public Logger getLogger() {
        return this.logger;
    }

    public LoggerFactory getLoggerFactory() {
        return this.loggerFactory;
    }

    public String getFcState() {
        return null;
    }

    public void setLoggerFactory(LoggerFactory loggerFactory) {
        this.loggerFactory = loggerFactory;
        this.logger = this.getLoggerFactory().getLogger("logger");
    }

    public void startFc() throws IllegalLifeCycleException {
        try {
            this.start();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    public void stopFc() throws IllegalLifeCycleException {
        try {
            this.stop();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    @LifeCycle(on=LifeCycleType.START)
    public void start() {
        this.log = new LoggingUtil(this.logger);
        this.log.debug((Object)"Starting...");
        this.sendTimeout = this.configurationService.getContainerConfiguration().getTCPSendTimeout();
        this.pendingSyncExchanges = new ConcurrentHashMap<String, MessageExchangeWrapper>(100);
    }

    @LifeCycle(on=LifeCycleType.STOP)
    public void stop() {
        this.log.debug((Object)"Stopping...");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void send(MessageExchangeWrapper messageExchangeWrapper, TransportSendContext transportSendContext) throws TransportException {
        this.log.start((Object)("Send exchange to destination '" + transportSendContext.destination + "'"));
        boolean bl = this.interceptSend(messageExchangeWrapper, transportSendContext);
        if (!bl) {
            return;
        }
        this.checkTransporterState();
        try {
            Client client = this.clientFactory.getClient(transportSendContext.destination.getContainerName());
            if (client == null) {
                throw new TransportException("Can not find a client to reach remote container");
            }
            try {
                client.send(messageExchangeWrapper, this.sendTimeout);
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                this.clientFactory.releaseClient(transportSendContext.destination.getContainerName(), client);
                throw throwable;
            }
            {
                Object var5_8 = null;
                this.clientFactory.releaseClient(transportSendContext.destination.getContainerName(), client);
            }
        }
        catch (Exception exception) {
            throw new TransportException((Throwable)exception);
        }
        this.log.end();
    }

    private boolean interceptSend(MessageExchangeWrapper messageExchangeWrapper, TransportSendContext transportSendContext) {
        boolean bl = true;
        if (this.sendInterceptor == null) {
            return true;
        }
        try {
            Constants.STATUS sTATUS = this.sendInterceptor.send(messageExchangeWrapper, transportSendContext);
            bl = sTATUS == Constants.STATUS.CONTINUE;
        }
        catch (ClientException clientException) {
            clientException.printStackTrace();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendSync(MessageExchangeWrapper messageExchangeWrapper, TransportSendContext transportSendContext) throws TransportException {
        MessageExchangeWrapper messageExchangeWrapper2;
        this.log.start((Object)("Send synchronous exchange to destination : " + transportSendContext.destination));
        this.checkTransporterState();
        try {
            TransporterUtil.setSendSyncProperties((MessageExchangeWrapper)messageExchangeWrapper);
        }
        catch (MessagingException messagingException) {
            throw new TransportException((Throwable)messagingException);
        }
        this.pendingSyncExchanges.put(messageExchangeWrapper.getExchangeId(), messageExchangeWrapper);
        try {
            MessageExchangeWrapper messageExchangeWrapper3 = messageExchangeWrapper;
            synchronized (messageExchangeWrapper3) {
                this.send(messageExchangeWrapper, transportSendContext);
                messageExchangeWrapper.wait(transportSendContext.timeout);
            }
            messageExchangeWrapper2 = this.pendingSyncExchanges.remove(messageExchangeWrapper.getExchangeId());
        }
        catch (InterruptedException interruptedException) {
            TransporterUtil.updateSyncProperties((MessageExchangeWrapper)messageExchangeWrapper);
            this.pendingSyncExchanges.remove(messageExchangeWrapper);
            throw new TransportException("Failed to receive the response message of a synchronous send", (Throwable)interruptedException);
        }
        if (messageExchangeWrapper2 == messageExchangeWrapper) {
            this.checkTransporterState();
            messageExchangeWrapper.setTimeout(true);
            this.log.warning((Object)("Failed to send synchronously the exchange: " + messageExchangeWrapper.getExchangeId() + ". Timeout occured"));
            this.log.end();
        } else {
            try {
                messageExchangeWrapper.setMessageExchange(messageExchangeWrapper2.getMessageExchange());
            }
            catch (MessagingException messagingException) {
                throw new TransportException((Throwable)messagingException);
            }
        }
        this.log.end();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopTraffic() {
        this.log.start();
        this.stopTraffic = true;
        boolean bl = true;
        while (bl) {
            try {
                Iterator<MessageExchangeWrapper> iterator = this.pendingSyncExchanges.values().iterator();
                while (iterator.hasNext()) {
                    MessageExchangeWrapper messageExchangeWrapper;
                    MessageExchangeWrapper messageExchangeWrapper2 = messageExchangeWrapper = iterator.next();
                    synchronized (messageExchangeWrapper2) {
                        messageExchangeWrapper.notify();
                    }
                }
                bl = false;
            }
            catch (ConcurrentModificationException concurrentModificationException) {}
        }
        this.log.end();
    }

    private void checkTransporterState() throws TransportException {
        if (this.stopTraffic) {
            Thread.currentThread().interrupt();
            throw new TransportException("The Transporter traffic is stopped", (Throwable)new InterruptedException());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(MessageExchangeWrapper messageExchangeWrapper) {
        this.log.start();
        boolean bl = this.interceptReceive(messageExchangeWrapper);
        if (!bl) {
            return;
        }
        boolean bl2 = this.getSyncMode(messageExchangeWrapper, true);
        if (bl2) {
            MessageExchangeWrapper messageExchangeWrapper2;
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("The message " + messageExchangeWrapper.getExchangeId() + " is a synchronized response"));
            }
            TransporterUtil.updateSyncProperties((MessageExchangeWrapper)messageExchangeWrapper);
            MessageExchangeWrapper messageExchangeWrapper3 = messageExchangeWrapper2 = this.pendingSyncExchanges.put(messageExchangeWrapper.getExchangeId(), messageExchangeWrapper);
            synchronized (messageExchangeWrapper3) {
                messageExchangeWrapper2.notify();
            }
        } else {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("The message " + messageExchangeWrapper.getExchangeId() + " is not a synchronized response"));
            }
            this.transportListener.onExchange(messageExchangeWrapper);
        }
        this.log.end();
    }

    public void bindFc(String string, Object object) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("logger")) {
            this.logger = (Logger)object;
            return;
        }
        if (string.equals("logger-factory")) {
            this.setLoggerFactory((LoggerFactory)object);
            return;
        }
        if (string.equals("configuration")) {
            if (!ConfigurationService.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + ConfigurationService.class.getName());
            }
            this.configurationService = (ConfigurationService)object;
            return;
        }
        if (string.equals("transportlistener")) {
            if (!TransportListener.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + TransportListener.class.getName());
            }
            this.transportListener = (TransportListener)object;
            return;
        }
        if (string.equals("clientfactory")) {
            if (!ClientFactory.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + ClientFactory.class.getName());
            }
            this.clientFactory = (ClientFactory)object;
            return;
        }
        if (string.equals("sendinterceptor")) {
            if (!SendInterceptor.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + SendInterceptor.class.getName());
            }
            this.sendInterceptor = (SendInterceptor)object;
            return;
        }
        if (string.equals("receiveinterceptor")) {
            if (!ReceiveInterceptor.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + ReceiveInterceptor.class.getName());
            }
            this.receiveInterceptor = (ReceiveInterceptor)object;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public String[] listFc() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("configuration");
        arrayList.add("transportlistener");
        arrayList.add("clientfactory");
        arrayList.add("sendinterceptor");
        arrayList.add("receiveinterceptor");
        return arrayList.toArray(new String[0]);
    }

    private boolean interceptReceive(MessageExchangeWrapper messageExchangeWrapper) {
        boolean bl = true;
        if (this.receiveInterceptor == null) {
            return true;
        }
        Constants.STATUS sTATUS = this.receiveInterceptor.receive(messageExchangeWrapper);
        bl = sTATUS == Constants.STATUS.CONTINUE;
        return bl;
    }

    public Object lookupFc(String string) throws NoSuchInterfaceException {
        if (string.equals("configuration")) {
            return this.configurationService;
        }
        if (string.equals("transportlistener")) {
            return this.transportListener;
        }
        if (string.equals("clientfactory")) {
            return this.clientFactory;
        }
        if (string.equals("sendinterceptor")) {
            return this.sendInterceptor;
        }
        if (string.equals("receiveinterceptor")) {
            return this.receiveInterceptor;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    private boolean getSyncMode(MessageExchangeWrapper messageExchangeWrapper, boolean bl) {
        boolean bl2 = MessageExchange.Role.CONSUMER.equals(messageExchangeWrapper.getRole()) && bl || MessageExchange.Role.PROVIDER.equals(messageExchangeWrapper.getRole()) && !bl ? Boolean.parseBoolean((String)messageExchangeWrapper.getProperty("org.ow2.petals.messaging.sendSync.consumer")) : Boolean.parseBoolean((String)messageExchangeWrapper.getProperty("org.ow2.petals.messaging.sendSync.provider"));
        return bl2;
    }

    public void unbindFc(String string) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("configuration")) {
            this.configurationService = null;
            return;
        }
        if (string.equals("transportlistener")) {
            this.transportListener = null;
            return;
        }
        if (string.equals("clientfactory")) {
            this.clientFactory = null;
            return;
        }
        if (string.equals("sendinterceptor")) {
            this.sendInterceptor = null;
            return;
        }
        if (string.equals("receiveinterceptor")) {
            this.receiveInterceptor = null;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public void setConfigurationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

    public void setTransportListener(TransportListener transportListener) {
        this.transportListener = transportListener;
    }

    public void setClientFactory(ClientFactory clientFactory) {
        this.clientFactory = clientFactory;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public void setSendInterceptor(SendInterceptor sendInterceptor) {
        this.sendInterceptor = sendInterceptor;
    }

    public void setReceiveInterceptor(ReceiveInterceptor receiveInterceptor) {
        this.receiveInterceptor = receiveInterceptor;
    }
}

