/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easycommons.xml;

import com.ebmwebsourcing.easycommons.lang.UncheckedException;
import com.ebmwebsourcing.easycommons.stream.InputStreamForker;
import com.ebmwebsourcing.easycommons.stream.ReaderInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public class SourceHelper {
    private static final Transformer transformer;

    public static String toString(Source source) throws TransformerException {
        StringWriter writer = new StringWriter();
        StreamResult result = new StreamResult(writer);
        transformer.transform(source, result);
        return writer.toString();
    }

    private static final Source forkStreamSource(StreamSource source) throws IOException {
        InputStreamForker streamForker = source.getInputStream() != null ? new InputStreamForker(source.getInputStream()) : new InputStreamForker((InputStream)new ReaderInputStream(source.getReader()));
        source.setInputStream(streamForker.fork());
        return new StreamSource(streamForker.fork());
    }

    public static Source fork(Source source) throws IOException {
        if (source instanceof DOMSource) {
            return source;
        }
        if (source instanceof StreamSource) {
            return SourceHelper.forkStreamSource((StreamSource)source);
        }
        throw new IllegalArgumentException("Only DOMSource or StreamSource are supported right now.");
    }

    static {
        try {
            transformer = TransformerFactory.newInstance().newTransformer();
        }
        catch (TransformerConfigurationException e) {
            throw new UncheckedException("Failed to create Transformer", (Throwable)e);
        }
    }
}

