/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easycommons.xml.resolver;

import com.ebmwebsourcing.easycommons.xml.resolver.BaseURINullResolver;
import com.ebmwebsourcing.easycommons.xml.resolver.JARResolver;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.sax.SAXSource;
import org.xml.sax.InputSource;

public class URIMultipleResolvers
implements URIResolver {
    private List<URIResolver> resolvers = new ArrayList<URIResolver>();

    public URIMultipleResolvers() {
        this(new BaseURINullResolver(), new JARResolver());
    }

    public URIMultipleResolvers(URIResolver ... resolvers) {
        for (URIResolver resolver : resolvers) {
            this.resolvers.add(resolver);
        }
    }

    @Override
    public Source resolve(String href, String base) throws TransformerException {
        Source res = null;
        for (URIResolver resolver : this.resolvers) {
            try {
                res = resolver.resolve(href, base);
                if (res == null) continue;
                break;
            }
            catch (TransformerException e) {
                e.printStackTrace();
            }
        }
        if (res == null && base != null && href != null) {
            URI baseURI = URI.create(base);
            try {
                res = new SAXSource(new InputSource(baseURI.resolve(href).toURL().openStream()));
            }
            catch (MalformedURLException e) {
                throw new TransformerException(e);
            }
            catch (IOException e) {
                throw new TransformerException(e);
            }
        }
        return res;
    }

    public void addURIResolver(URIResolver r) {
        this.resolvers.add(r);
    }

    public URIResolver[] getURIResolvers() {
        return this.resolvers.toArray(new URIResolver[this.resolvers.size()]);
    }
}

