/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.endpoint;

import com.ibm.wsdl.extensions.soap.SOAPBindingImpl;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.binding.Binding;
import org.apache.cxf.common.i18n.UncheckedException;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.endpoint.ClientCallback;
import org.apache.cxf.endpoint.ClientLifeCycleManager;
import org.apache.cxf.endpoint.ConduitSelector;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.endpoint.EndpointException;
import org.apache.cxf.endpoint.EndpointImpl;
import org.apache.cxf.endpoint.EndpointImplFactory;
import org.apache.cxf.endpoint.PreexistingConduitSelector;
import org.apache.cxf.endpoint.Retryable;
import org.apache.cxf.endpoint.SimpleEndpointImplFactory;
import org.apache.cxf.endpoint.UpfrontConduitSelector;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.interceptor.AbstractBasicInterceptorProvider;
import org.apache.cxf.interceptor.ClientOutFaultObserver;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.InterceptorChain;
import org.apache.cxf.interceptor.InterceptorProvider;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.ExchangeImpl;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageContentsList;
import org.apache.cxf.message.MessageImpl;
import org.apache.cxf.phase.PhaseChainCache;
import org.apache.cxf.phase.PhaseInterceptorChain;
import org.apache.cxf.phase.PhaseManager;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.model.BindingInfo;
import org.apache.cxf.service.model.BindingMessageInfo;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.service.model.InterfaceInfo;
import org.apache.cxf.service.model.MessageInfo;
import org.apache.cxf.service.model.OperationInfo;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.cxf.transport.Conduit;
import org.apache.cxf.transport.MessageObserver;
import org.apache.cxf.workqueue.SynchronousExecutor;
import org.apache.cxf.wsdl11.WSDLServiceFactory;

public class ClientImpl
extends AbstractBasicInterceptorProvider
implements Client,
Retryable,
MessageObserver {
    public static final String THREAD_LOCAL_REQUEST_CONTEXT = "thread.local.request.context";
    public static final String FINISHED = "exchange.finished";
    private static final Logger LOG = LogUtils.getL7dLogger(ClientImpl.class);
    protected Bus bus;
    protected ConduitSelector conduitSelector;
    protected ClientOutFaultObserver outFaultObserver;
    protected int synchronousTimeout = 60000;
    protected PhaseChainCache outboundChainCache = new PhaseChainCache();
    protected PhaseChainCache inboundChainCache = new PhaseChainCache();
    protected Map<String, Object> currentRequestContext = new ConcurrentHashMap<String, Object>();
    protected Map<Thread, EchoContext> requestContext = Collections.synchronizedMap(new WeakHashMap());
    protected Map<Thread, Map<String, Object>> responseContext = Collections.synchronizedMap(new WeakHashMap());
    protected Executor executor;

    public ClientImpl(Bus b, Endpoint e) {
        this(b, e, (ConduitSelector)null);
    }

    public ClientImpl(Bus b, Endpoint e, Conduit c) {
        this(b, e, (ConduitSelector)new PreexistingConduitSelector(c));
    }

    public ClientImpl(Bus b, Endpoint e, ConduitSelector sc) {
        this.bus = b;
        this.outFaultObserver = new ClientOutFaultObserver(this.bus);
        this.getConduitSelector(sc).setEndpoint(e);
        this.notifyLifecycleManager();
    }

    public ClientImpl(URL wsdlUrl) {
        this(BusFactory.getThreadDefaultBus(), wsdlUrl, null, null, SimpleEndpointImplFactory.getSingleton());
    }

    public ClientImpl(URL wsdlUrl, QName port) {
        this(BusFactory.getThreadDefaultBus(), wsdlUrl, null, port, SimpleEndpointImplFactory.getSingleton());
    }

    public ClientImpl(Bus bus, URL wsdlUrl, QName service, QName port) {
        this(bus, wsdlUrl, service, port, SimpleEndpointImplFactory.getSingleton());
    }

    public ClientImpl(Bus bus, URL wsdlUrl, QName service, QName port, EndpointImplFactory endpointImplFactory) {
        this.bus = bus;
        this.outFaultObserver = new ClientOutFaultObserver(bus);
        WSDLServiceFactory sf = service == null ? new WSDLServiceFactory(bus, wsdlUrl) : new WSDLServiceFactory(bus, wsdlUrl, service);
        Service svc = sf.create();
        EndpointInfo epfo = this.findEndpoint(svc, port);
        try {
            if (endpointImplFactory != null) {
                this.getConduitSelector().setEndpoint((Endpoint)endpointImplFactory.newEndpointImpl(bus, svc, epfo));
            } else {
                this.getConduitSelector().setEndpoint((Endpoint)new EndpointImpl(bus, svc, epfo));
            }
        }
        catch (EndpointException epex) {
            throw new IllegalStateException("Unable to create endpoint: " + epex.getMessage(), (Throwable)((Object)epex));
        }
        this.notifyLifecycleManager();
    }

    public Bus getBus() {
        return this.bus;
    }

    public void destroy() {
        ClientLifeCycleManager mgr = (ClientLifeCycleManager)this.bus.getExtension(ClientLifeCycleManager.class);
        if (null != mgr) {
            mgr.clientDestroyed((Client)this);
        }
        if (this.conduitSelector != null) {
            this.getConduit().close();
        }
    }

    private void notifyLifecycleManager() {
        ClientLifeCycleManager mgr = (ClientLifeCycleManager)this.bus.getExtension(ClientLifeCycleManager.class);
        if (null != mgr) {
            mgr.clientCreated((Client)this);
        }
    }

    private EndpointInfo findEndpoint(Service svc, QName port) {
        EndpointInfo epfo;
        if (port != null) {
            epfo = svc.getEndpointInfo(port);
            if (epfo == null) {
                throw new IllegalArgumentException("The service " + svc.getName() + " does not have an endpoint " + port + ".");
            }
        } else {
            epfo = null;
            for (ServiceInfo svcfo : svc.getServiceInfos()) {
                block1: for (EndpointInfo e : svcfo.getEndpoints()) {
                    BindingInfo bfo = e.getBinding();
                    if (!bfo.getBindingId().equals("http://schemas.xmlsoap.org/wsdl/soap/")) continue;
                    for (Object o : (Object[])bfo.getExtensors().get()) {
                        SOAPBindingImpl soapB;
                        if (!(o instanceof SOAPBindingImpl) || !(soapB = (SOAPBindingImpl)o).getTransportURI().equals("http://schemas.xmlsoap.org/soap/http")) continue;
                        epfo = e;
                        continue block1;
                    }
                }
            }
            if (epfo == null) {
                throw new UnsupportedOperationException("Only document-style SOAP 1.1 http are supported for auto-selection of endpoint; none were found.");
            }
        }
        return epfo;
    }

    public Endpoint getEndpoint() {
        return this.getConduitSelector().getEndpoint();
    }

    public Map<String, Object> getRequestContext() {
        if (this.isThreadLocalRequestContext()) {
            if (!this.requestContext.containsKey(Thread.currentThread())) {
                this.requestContext.put(Thread.currentThread(), new EchoContext(this.currentRequestContext));
            }
            return this.requestContext.get(Thread.currentThread());
        }
        return this.currentRequestContext;
    }

    public Map<String, Object> getResponseContext() {
        if (!this.responseContext.containsKey(Thread.currentThread())) {
            this.responseContext.put(Thread.currentThread(), new HashMap());
        }
        return this.responseContext.get(Thread.currentThread());
    }

    public boolean isThreadLocalRequestContext() {
        if (this.currentRequestContext.containsKey(THREAD_LOCAL_REQUEST_CONTEXT)) {
            Object o = this.currentRequestContext.get(THREAD_LOCAL_REQUEST_CONTEXT);
            boolean local = false;
            local = o instanceof Boolean ? (Boolean)o : Boolean.parseBoolean(o.toString());
            return local;
        }
        return false;
    }

    public void setThreadLocalRequestContext(boolean b) {
        this.currentRequestContext.put(THREAD_LOCAL_REQUEST_CONTEXT, b);
    }

    public Object[] invoke(BindingOperationInfo oi, Object ... params) throws Exception {
        return this.invoke(oi, params, (Exchange)null);
    }

    public Object[] invoke(String operationName, Object ... params) throws Exception {
        QName q = new QName(this.getEndpoint().getService().getName().getNamespaceURI(), operationName);
        return this.invoke(q, params);
    }

    public Object[] invoke(QName operationName, Object ... params) throws Exception {
        BindingOperationInfo op = this.getEndpoint().getEndpointInfo().getBinding().getOperation(operationName);
        if (op == null) {
            throw new UncheckedException(new org.apache.cxf.common.i18n.Message("NO_OPERATION", LOG, new Object[]{operationName}));
        }
        if (op.isUnwrappedCapable()) {
            op = op.getUnwrappedOperation();
        }
        return this.invoke(op, params);
    }

    public Object[] invokeWrapped(String operationName, Object ... params) throws Exception {
        QName q = new QName(this.getEndpoint().getService().getName().getNamespaceURI(), operationName);
        return this.invokeWrapped(q, params);
    }

    public Object[] invokeWrapped(QName operationName, Object ... params) throws Exception {
        BindingOperationInfo op = this.getEndpoint().getEndpointInfo().getBinding().getOperation(operationName);
        if (op == null) {
            throw new UncheckedException(new org.apache.cxf.common.i18n.Message("NO_OPERATION", LOG, new Object[]{operationName}));
        }
        return this.invoke(op, params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] invoke(BindingOperationInfo oi, Object[] params, Exchange exchange) throws Exception {
        HashMap<String, Object> context = new HashMap<String, Object>();
        HashMap resp = new HashMap();
        resp.clear();
        HashMap<String, Object> req = new HashMap<String, Object>(this.getRequestContext());
        context.put("ResponseContext", resp);
        context.put("RequestContext", req);
        try {
            Object[] objectArray = this.invoke(oi, params, context, exchange);
            return objectArray;
        }
        finally {
            this.responseContext.put(Thread.currentThread(), resp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] invoke(BindingOperationInfo oi, Object[] params, Map<String, Object> context) throws Exception {
        try {
            Object[] objectArray = this.invoke(oi, params, context, (Exchange)null);
            return objectArray;
        }
        finally {
            Map resp;
            if (context != null && (resp = CastUtils.cast((Map)((Map)context.get("ResponseContext")))) != null) {
                this.responseContext.put(Thread.currentThread(), resp);
            }
        }
    }

    public void invoke(ClientCallback callback, String operationName, Object ... params) throws Exception {
        QName q = new QName(this.getEndpoint().getService().getName().getNamespaceURI(), operationName);
        this.invoke(callback, q, params);
    }

    public void invoke(ClientCallback callback, QName operationName, Object ... params) throws Exception {
        BindingOperationInfo op = this.getEndpoint().getEndpointInfo().getBinding().getOperation(operationName);
        if (op == null) {
            throw new UncheckedException(new org.apache.cxf.common.i18n.Message("NO_OPERATION", LOG, new Object[]{operationName}));
        }
        if (op.isUnwrappedCapable()) {
            op = op.getUnwrappedOperation();
        }
        this.invoke(callback, op, params);
    }

    public void invokeWrapped(ClientCallback callback, String operationName, Object ... params) throws Exception {
        QName q = new QName(this.getEndpoint().getService().getName().getNamespaceURI(), operationName);
        this.invokeWrapped(callback, q, params);
    }

    public void invokeWrapped(ClientCallback callback, QName operationName, Object ... params) throws Exception {
        BindingOperationInfo op = this.getEndpoint().getEndpointInfo().getBinding().getOperation(operationName);
        if (op == null) {
            throw new UncheckedException(new org.apache.cxf.common.i18n.Message("NO_OPERATION", LOG, new Object[]{operationName}));
        }
        this.invoke(callback, op, params);
    }

    public void invoke(ClientCallback callback, BindingOperationInfo oi, Object ... params) throws Exception {
        this.invoke(callback, oi, params, null, null);
    }

    public void invoke(ClientCallback callback, BindingOperationInfo oi, Object[] params, Map<String, Object> context) throws Exception {
        this.invoke(callback, oi, params, context, null);
    }

    public void invoke(ClientCallback callback, BindingOperationInfo oi, Object[] params, Exchange exchange) throws Exception {
        this.invoke(callback, oi, params, null, exchange);
    }

    public void invoke(ClientCallback callback, BindingOperationInfo oi, Object[] params, Map<String, Object> context, Exchange exchange) throws Exception {
        this.doInvoke(callback, oi, params, context, exchange);
    }

    public Object[] invoke(BindingOperationInfo oi, Object[] params, Map<String, Object> context, Exchange exchange) throws Exception {
        return this.doInvoke(null, oi, params, context, exchange);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object[] doInvoke(ClientCallback callback, BindingOperationInfo oi, Object[] params, Map<String, Object> context, Exchange exchange) throws Exception {
        Bus origBus = BusFactory.getThreadDefaultBus((boolean)false);
        ClassLoader origLoader = Thread.currentThread().getContextClassLoader();
        try {
            BusFactory.setThreadDefaultBus((Bus)this.bus);
            ClassLoader loader = (ClassLoader)this.bus.getExtension(ClassLoader.class);
            if (loader != null) {
                Thread.currentThread().setContextClassLoader(loader);
            }
            if (exchange == null) {
                exchange = new ExchangeImpl();
            }
            exchange.setSynchronous(callback == null);
            Endpoint endpoint = this.getEndpoint();
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Invoke, operation info: " + oi + ", params: " + Arrays.toString(params));
            }
            Message message = endpoint.getBinding().createMessage();
            HashMap<String, Object> reqContext = null;
            HashMap<String, Object> resContext = null;
            if (context == null) {
                context = new HashMap<String, Object>();
            }
            reqContext = CastUtils.cast((Map)((Map)context.get("RequestContext")));
            resContext = CastUtils.cast((Map)((Map)context.get("ResponseContext")));
            if (reqContext == null) {
                reqContext = new HashMap<String, Object>(this.getRequestContext());
                context.put("RequestContext", reqContext);
            }
            if (resContext == null) {
                resContext = new HashMap<String, Object>();
                context.put("ResponseContext", resContext);
            }
            message.put((Object)"org.apache.cxf.invocation.context", context);
            this.setContext(reqContext, message);
            if (null != reqContext) {
                exchange.putAll(reqContext);
            }
            this.setParameters(params, message);
            if (null != oi) {
                exchange.setOneWay(oi.getOutput() == null);
            }
            exchange.setOutMessage(message);
            exchange.put(ClientCallback.class, (Object)callback);
            this.setOutMessageProperties(message, oi);
            this.setExchangeProperties(exchange, endpoint, oi);
            PhaseInterceptorChain chain = this.setupInterceptorChain(endpoint);
            message.setInterceptorChain((InterceptorChain)chain);
            chain.setFaultObserver((MessageObserver)this.outFaultObserver);
            this.prepareConduitSelector(message);
            this.modifyChain((InterceptorChain)chain, message, false);
            try {
                chain.doIntercept(message);
            }
            catch (Fault fault) {
                this.enrichFault(fault);
                throw fault;
            }
            if (callback != null) {
                Object[] objectArray = null;
                return objectArray;
            }
            Object[] objectArray = this.processResult(message, exchange, oi, resContext);
            return objectArray;
        }
        finally {
            Thread.currentThread().setContextClassLoader(origLoader);
            BusFactory.setThreadDefaultBus((Bus)origBus);
        }
    }

    private void enrichFault(Fault fault) {
        if (fault.getCause().getCause() instanceof IOException || fault.getCause() instanceof IOException) {
            String soap11NS = "http://schemas.xmlsoap.org/soap/envelope/";
            String soap12NS = "http://www.w3.org/2003/05/soap-envelope";
            QName faultCode = fault.getFaultCode();
            if (faultCode.getNamespaceURI().equals(soap11NS) && faultCode.getLocalPart().equals("Client")) {
                faultCode = new QName(soap11NS, "Server");
                fault.setFaultCode(faultCode);
            }
            if (faultCode.getNamespaceURI().equals(soap12NS) && faultCode.getLocalPart().equals("Sender")) {
                faultCode = new QName(soap12NS, "Receiver");
                fault.setFaultCode(faultCode);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object[] processResult(Message message, Exchange exchange, BindingOperationInfo oi, Map<String, Object> resContext) throws Exception {
        Boolean keepConduitAlive;
        Exception ex = null;
        if (!message.get((Object)"org.apache.cxf.message.inbound").equals(Boolean.TRUE)) {
            ex = (Exception)message.getContent(Exception.class);
        }
        boolean mepCompleteCalled = false;
        if (ex != null) {
            this.getConduitSelector().complete(exchange);
            mepCompleteCalled = true;
            if (message.getContent(Exception.class) != null) {
                throw ex;
            }
        }
        if ((ex = (Exception)message.getExchange().get(Exception.class)) != null) {
            if (!mepCompleteCalled) {
                this.getConduitSelector().complete(exchange);
            }
            throw ex;
        }
        if (oi != null && !oi.getOperationInfo().isOneWay()) {
            Exchange exchange2 = exchange;
            synchronized (exchange2) {
                this.waitResponse(exchange);
            }
        }
        if ((keepConduitAlive = (Boolean)exchange.get((Object)"KeepConduitAlive")) == null || !keepConduitAlive.booleanValue()) {
            this.getConduitSelector().complete(exchange);
        }
        List resList = null;
        Message inMsg = exchange.getInMessage();
        if (inMsg != null) {
            if (null != resContext) {
                resContext.putAll((Map<String, Object>)inMsg);
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("set responseContext to be" + resContext);
                }
                this.responseContext.put(Thread.currentThread(), resContext);
            }
            resList = (List)inMsg.getContent(List.class);
        }
        if ((ex = this.getException(exchange)) != null) {
            throw ex;
        }
        if (resList != null) {
            return resList.toArray();
        }
        return null;
    }

    protected Exception getException(Exchange exchange) {
        if (exchange.getInFaultMessage() != null) {
            return (Exception)exchange.getInFaultMessage().getContent(Exception.class);
        }
        if (exchange.getOutFaultMessage() != null) {
            return (Exception)exchange.getOutFaultMessage().getContent(Exception.class);
        }
        if (exchange.getInMessage() != null) {
            return (Exception)exchange.getInMessage().getContent(Exception.class);
        }
        return null;
    }

    protected void setContext(Map<String, Object> ctx, Message message) {
        if (ctx != null) {
            message.putAll(ctx);
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("set requestContext to message be" + ctx);
            }
        }
    }

    protected void waitResponse(Exchange exchange) {
        long start;
        long end;
        for (int remaining = this.synchronousTimeout; !Boolean.TRUE.equals(exchange.get((Object)FINISHED)) && remaining > 0; remaining -= (int)(end - start)) {
            start = System.currentTimeMillis();
            try {
                exchange.wait(remaining);
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
            end = System.currentTimeMillis();
        }
        if (!Boolean.TRUE.equals(exchange.get((Object)FINISHED))) {
            LogUtils.log((Logger)LOG, (Level)Level.WARNING, (String)"RESPONSE_TIMEOUT", (Object)((OperationInfo)exchange.get(OperationInfo.class)).getName().toString());
        }
    }

    protected void setParameters(Object[] params, Message message) {
        MessageContentsList contents = new MessageContentsList(params);
        message.setContent(List.class, (Object)contents);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(Message message) {
        PhaseInterceptorChain chain;
        Endpoint endpoint = message.getExchange().getEndpoint();
        if (endpoint == null) {
            endpoint = this.getConduitSelector().getEndpoint();
            message.getExchange().put(Endpoint.class, (Object)endpoint);
        }
        message = endpoint.getBinding().createMessage(message);
        message.getExchange().setInMessage(message);
        message.put((Object)"org.apache.cxf.client", (Object)Boolean.TRUE);
        message.put((Object)"org.apache.cxf.message.inbound", (Object)Boolean.TRUE);
        PhaseManager pm = (PhaseManager)this.bus.getExtension(PhaseManager.class);
        List i1 = this.bus.getInInterceptors();
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Interceptors contributed by bus: " + i1);
        }
        List i2 = this.getInInterceptors();
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Interceptors contributed by client: " + i2);
        }
        List i3 = endpoint.getInInterceptors();
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Interceptors contributed by endpoint: " + i3);
        }
        List i4 = endpoint.getBinding().getInInterceptors();
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Interceptors contributed by binding: " + i4);
        }
        if (endpoint.getService().getDataBinding() instanceof InterceptorProvider) {
            InterceptorProvider p = (InterceptorProvider)endpoint.getService().getDataBinding();
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Interceptors contributed by databinging: " + p.getInInterceptors());
            }
            chain = this.inboundChainCache.get(pm.getInPhases(), i1, i2, i3, i4, p.getInInterceptors());
        } else {
            chain = this.inboundChainCache.get(pm.getInPhases(), i1, i2, i3, i4);
        }
        message.setInterceptorChain((InterceptorChain)chain);
        chain.setFaultObserver((MessageObserver)this.outFaultObserver);
        this.modifyChain((InterceptorChain)chain, message, true);
        this.modifyChain((InterceptorChain)chain, message.getExchange().getOutMessage(), true);
        Bus origBus = BusFactory.getThreadDefaultBus((boolean)false);
        BusFactory.setThreadDefaultBus((Bus)this.bus);
        ClientCallback callback = (ClientCallback)message.getExchange().get(ClientCallback.class);
        try {
            if (callback != null) {
                if (callback.isCancelled()) {
                    this.getConduitSelector().complete(message.getExchange());
                    return;
                }
                callback.start(message);
            }
            String startingAfterInterceptorID = (String)message.get((Object)"starting_after_interceptor_id");
            String startingInterceptorID = (String)message.get((Object)"starting_at_interceptor_id");
            if (startingAfterInterceptorID != null) {
                chain.doInterceptStartingAfter(message, startingAfterInterceptorID);
            } else if (startingInterceptorID != null) {
                chain.doInterceptStartingAt(message, startingInterceptorID);
            } else if (message.getContent(Exception.class) != null) {
                this.outFaultObserver.onMessage(message);
            } else {
                callback = (ClientCallback)message.getExchange().get(ClientCallback.class);
                if (callback != null && !this.isPartialResponse(message)) {
                    try {
                        chain.doIntercept(message);
                    }
                    catch (Throwable error) {
                        message.getExchange().setInMessage(message);
                        Map resCtx = CastUtils.cast((Map)((Map)message.getExchange().getOutMessage().get((Object)"org.apache.cxf.invocation.context")));
                        resCtx = CastUtils.cast((Map)((Map)resCtx.get("ResponseContext")));
                        if (resCtx != null) {
                            this.responseContext.put(Thread.currentThread(), resCtx);
                        }
                        callback.handleException(resCtx, error);
                    }
                } else {
                    chain.doIntercept(message);
                }
            }
            callback = (ClientCallback)message.getExchange().get(ClientCallback.class);
            if (callback != null && !this.isPartialResponse(message)) {
                message.getExchange().setInMessage(message);
                Map resCtx = CastUtils.cast((Map)((Map)message.getExchange().getOutMessage().get((Object)"org.apache.cxf.invocation.context")));
                resCtx = CastUtils.cast((Map)((Map)resCtx.get("ResponseContext")));
                if (resCtx != null) {
                    this.responseContext.put(Thread.currentThread(), resCtx);
                }
                try {
                    Object[] obj = this.processResult(message, message.getExchange(), null, resCtx);
                    callback.handleResponse(resCtx, obj);
                }
                catch (Throwable ex) {
                    callback.handleException(resCtx, ex);
                }
            }
        }
        finally {
            Exchange exchange = message.getExchange();
            synchronized (exchange) {
                if (!this.isPartialResponse(message) && callback == null) {
                    message.getExchange().put((Object)FINISHED, (Object)Boolean.TRUE);
                    message.getExchange().setInMessage(message);
                    message.getExchange().notifyAll();
                }
            }
            BusFactory.setThreadDefaultBus((Bus)origBus);
        }
    }

    public Conduit getConduit() {
        MessageImpl message = new MessageImpl();
        ExchangeImpl exchange = new ExchangeImpl();
        message.setExchange((Exchange)exchange);
        this.setExchangeProperties((Exchange)exchange, null, null);
        return this.getConduitSelector().selectConduit((Message)message);
    }

    protected void prepareConduitSelector(Message message) {
        this.getConduitSelector().prepare(message);
        message.getExchange().put(ConduitSelector.class, (Object)this.getConduitSelector());
    }

    protected void setOutMessageProperties(Message message, BindingOperationInfo boi) {
        message.put((Object)"org.apache.cxf.client", (Object)Boolean.TRUE);
        message.put((Object)"org.apache.cxf.message.inbound", (Object)Boolean.FALSE);
        if (null != boi) {
            message.put(BindingMessageInfo.class, (Object)boi.getInput());
            message.put(MessageInfo.class, (Object)boi.getOperationInfo().getInput());
        }
    }

    protected void setExchangeProperties(Exchange exchange, Endpoint endpoint, BindingOperationInfo boi) {
        if (endpoint != null) {
            exchange.put(Endpoint.class, (Object)endpoint);
            exchange.put(Service.class, (Object)endpoint.getService());
            if (endpoint.getEndpointInfo().getService() != null) {
                exchange.put(ServiceInfo.class, (Object)endpoint.getEndpointInfo().getService());
                exchange.put(InterfaceInfo.class, (Object)endpoint.getEndpointInfo().getService().getInterface());
            }
            exchange.put(Binding.class, (Object)endpoint.getBinding());
            exchange.put(BindingInfo.class, (Object)endpoint.getEndpointInfo().getBinding());
        }
        if (boi != null) {
            exchange.put(BindingOperationInfo.class, (Object)boi);
            exchange.put(OperationInfo.class, (Object)boi.getOperationInfo());
        }
        if (exchange.isSynchronous() || this.executor == null) {
            exchange.put(MessageObserver.class, (Object)this);
        } else {
            exchange.put(Executor.class, (Object)this.executor);
            exchange.put(MessageObserver.class, (Object)new MessageObserver(){

                public void onMessage(final Message message) {
                    if (!message.getExchange().containsKey((Object)(Executor.class.getName() + ".USING_SPECIFIED"))) {
                        ClientImpl.this.executor.execute(new Runnable(){

                            @Override
                            public void run() {
                                ClientImpl.this.onMessage(message);
                            }
                        });
                    } else {
                        ClientImpl.this.onMessage(message);
                    }
                }
            });
        }
        exchange.put(Retryable.class, (Object)this);
        exchange.put(Client.class, (Object)this);
        exchange.put(Bus.class, (Object)this.bus);
        if (endpoint != null && boi != null) {
            EndpointInfo endpointInfo = endpoint.getEndpointInfo();
            exchange.put((Object)"javax.xml.ws.wsdl.operation", (Object)boi.getName());
            QName serviceQName = endpointInfo.getService().getName();
            exchange.put((Object)"javax.xml.ws.wsdl.service", (Object)serviceQName);
            QName interfaceQName = endpointInfo.getService().getInterface().getName();
            exchange.put((Object)"javax.xml.ws.wsdl.interface", (Object)interfaceQName);
            QName portQName = endpointInfo.getName();
            exchange.put((Object)"javax.xml.ws.wsdl.port", (Object)portQName);
            URI wsdlDescription = (URI)endpointInfo.getProperty("URI", URI.class);
            if (wsdlDescription == null) {
                String address = endpointInfo.getAddress();
                try {
                    wsdlDescription = new URI(address + "?wsdl");
                }
                catch (URISyntaxException e) {
                    // empty catch block
                }
                endpointInfo.setProperty("URI", (Object)wsdlDescription);
            }
            exchange.put((Object)"javax.xml.ws.wsdl.description", (Object)wsdlDescription);
        }
    }

    protected PhaseInterceptorChain setupInterceptorChain(Endpoint endpoint) {
        PhaseManager pm = (PhaseManager)this.bus.getExtension(PhaseManager.class);
        List i1 = this.bus.getOutInterceptors();
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Interceptors contributed by bus: " + i1);
        }
        List i2 = this.getOutInterceptors();
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Interceptors contributed by client: " + i2);
        }
        List i3 = endpoint.getOutInterceptors();
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Interceptors contributed by endpoint: " + i3);
        }
        List i4 = endpoint.getBinding().getOutInterceptors();
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Interceptors contributed by binding: " + i4);
        }
        List i5 = null;
        if (endpoint.getService().getDataBinding() instanceof InterceptorProvider) {
            i5 = ((InterceptorProvider)endpoint.getService().getDataBinding()).getOutInterceptors();
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Interceptors contributed by databinding: " + i5);
            }
        }
        if (i5 != null) {
            return this.outboundChainCache.get(pm.getOutPhases(), i1, i2, i3, i4, i5);
        }
        return this.outboundChainCache.get(pm.getOutPhases(), i1, i2, i3, i4);
    }

    protected void modifyChain(InterceptorChain chain, Message ctx, boolean in) {
        String key;
        Collection is;
        if (ctx == null) {
            return;
        }
        Collection providers = CastUtils.cast((Collection)((Collection)ctx.get((Object)Message.INTERCEPTOR_PROVIDERS)));
        if (providers != null) {
            for (InterceptorProvider p : providers) {
                if (in) {
                    chain.add((Collection)p.getInInterceptors());
                    continue;
                }
                chain.add((Collection)p.getOutInterceptors());
            }
        }
        if ((is = CastUtils.cast((Collection)((Collection)ctx.get((Object)(key = in ? Message.IN_INTERCEPTORS : Message.OUT_INTERCEPTORS))))) != null) {
            chain.add(is);
        }
    }

    protected void setEndpoint(Endpoint e) {
        this.getConduitSelector().setEndpoint(e);
    }

    public int getSynchronousTimeout() {
        return this.synchronousTimeout;
    }

    public void setSynchronousTimeout(int synchronousTimeout) {
        this.synchronousTimeout = synchronousTimeout;
    }

    public final ConduitSelector getConduitSelector() {
        return this.getConduitSelector(null);
    }

    protected final ConduitSelector getConduitSelector(ConduitSelector override) {
        if (null == this.conduitSelector) {
            this.setConduitSelector(override);
        }
        return this.conduitSelector;
    }

    public final synchronized void setConduitSelector(ConduitSelector selector) {
        this.conduitSelector = selector == null ? new UpfrontConduitSelector() : selector;
    }

    private boolean isPartialResponse(Message in) {
        return Boolean.TRUE.equals(in.get((Object)"org.apache.cxf.partial.response"));
    }

    public void setExecutor(Executor executor) {
        if (!SynchronousExecutor.isA(executor)) {
            this.executor = executor;
        }
    }

    public static class EchoContext
    extends HashMap<String, Object> {
        final Map<String, Object> shared;

        public EchoContext(Map<String, Object> sharedMap) {
            super(sharedMap);
            this.shared = sharedMap;
        }

        @Override
        public Object put(String key, Object value) {
            this.shared.put(key, value);
            return super.put(key, value);
        }

        @Override
        public void putAll(Map<? extends String, ? extends Object> t) {
            this.shared.putAll(t);
            super.putAll(t);
        }

        @Override
        public Object remove(Object key) {
            this.shared.remove(key);
            return super.remove(key);
        }

        public void reload() {
            super.clear();
            super.putAll(this.shared);
        }
    }
}

