/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.component.framework;

import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jbi.JBIException;
import javax.jbi.component.ComponentContext;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.InOptionalOut;
import javax.jbi.messaging.InOut;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessageExchangeFactory;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.xml.namespace.QName;
import org.ow2.petals.component.framework.api.Constants;
import org.ow2.petals.component.framework.message.ExchangeImpl;
import org.petalslink.dsb.service.client.Client;
import org.petalslink.dsb.service.client.ClientException;
import org.petalslink.dsb.service.client.Message;
import org.petalslink.dsb.service.client.MessageListener;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBIClient
implements Client {
    private ComponentContext componentContext;
    private Logger logger;
    private MessageExchangeFactory messageExchangeFactory;

    public JBIClient(ComponentContext componentContext) {
        this.componentContext = componentContext;
        try {
            this.messageExchangeFactory = this.componentContext.getDeliveryChannel().createExchangeFactory();
        }
        catch (MessagingException e) {
            e.printStackTrace();
        }
        try {
            this.logger = this.componentContext.getLogger("", null);
        }
        catch (MissingResourceException e) {
            e.printStackTrace();
        }
        catch (JBIException e) {
            e.printStackTrace();
        }
    }

    public String getName() {
        return "client-" + this.componentContext.getComponentName();
    }

    public void fireAndForget(Message message) throws ClientException {
        try {
            InOptionalOut messageExchange = this.messageExchangeFactory.createInOptionalOutExchange();
            this.send(message, new ExchangeImpl((MessageExchange)messageExchange), message.getOperation(), false);
        }
        catch (MessagingException e) {
            throw new ClientException((Throwable)e);
        }
    }

    public Message sendReceive(Message message) throws ClientException {
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine("SendReceive message");
        }
        Message result = null;
        try {
            InOut messageExchange = this.messageExchangeFactory.createInOutExchange();
            Document out = this.send(message, new ExchangeImpl((MessageExchange)messageExchange), message.getOperation(), true);
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine("Messager has been sent, we have a response");
            }
            result = this.createOutMessage(out);
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine("Out message is " + result);
            }
        }
        catch (MessagingException e) {
            throw new ClientException((Throwable)e);
        }
        return result;
    }

    protected Message createOutMessage(final Document out) {
        return new Message(){

            public Document getPayload() {
                return out;
            }

            public QName getOperation() {
                return null;
            }

            public Map<String, String> getProperties() {
                return null;
            }

            public Map<String, Document> getHeaders() {
                return null;
            }

            public QName getService() {
                return null;
            }

            public QName getInterface() {
                return null;
            }

            public String getEndpoint() {
                return null;
            }

            public String getProperty(String name) {
                return null;
            }

            public void setProperty(String name, String value) {
            }
        };
    }

    private Document send(Message message, ExchangeImpl messageExchange, QName operation, boolean synchronous) throws MessagingException, ClientException {
        Map<QName, String> addressing;
        NormalizedMessage normalizedMessage = messageExchange.getInMessage();
        messageExchange.setInMessageContent(message.getPayload());
        Map props = message.getProperties();
        if (props != null) {
            for (String key : props.keySet()) {
                normalizedMessage.setProperty(key, props.get(key));
            }
        }
        if ((addressing = this.getAddressing(message)).size() > 0) {
            messageExchange.setInAddressing(addressing);
        }
        messageExchange.setOperation(operation);
        if (message.getInterface() != null) {
            messageExchange.setInterfaceName(message.getInterface());
        }
        messageExchange.setService(message.getService());
        if (!synchronous) {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine("Let's send the message to the delivery channel with send()...");
            }
            this.componentContext.getDeliveryChannel().send(messageExchange.getMessageExchange());
        } else {
            boolean invoke;
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine("Let's send the message to the delivery channel with sendSync()");
            }
            if (invoke = this.componentContext.getDeliveryChannel().sendSync(messageExchange.getMessageExchange())) {
                if (ExchangeStatus.ERROR.equals(messageExchange.getStatus())) {
                    throw this.createFromOutMessage(messageExchange.getMessageExchange());
                }
                if (ExchangeStatus.ACTIVE.equals(messageExchange.getStatus())) {
                    normalizedMessage = messageExchange.getFault();
                    if (messageExchange.isOutMessage()) {
                        normalizedMessage = messageExchange.getOutMessage();
                    }
                    messageExchange.setDoneStatus();
                    this.componentContext.getDeliveryChannel().send(messageExchange.getMessageExchange());
                    if (normalizedMessage != null) {
                        return messageExchange.getOutMessageContentAsDocument();
                    }
                    System.out.println("No OUT... message");
                }
            } else {
                throw this.createFromOutMessage(messageExchange.getMessageExchange());
            }
        }
        return null;
    }

    public void sendAsync(Message message, MessageListener listener) throws ClientException {
        Message out = this.sendReceive(message);
        if (listener != null && out != null) {
            listener.onMessage(out);
        }
    }

    protected ClientException createFromOutMessage(MessageExchange messageExchange) {
        ClientException result = null;
        String message = null;
        if (ExchangeStatus.ERROR.equals(messageExchange.getStatus())) {
            message = "Got an ERROR while trying to send message to service, cause : TODO serialize ERROR";
            result = new ClientException(message);
        } else if (messageExchange.getFault() != null) {
            message = "Got a FAULT while invoking service, cause : TODO serialize Fault";
            result = new ClientException(message);
        } else {
            message = "Got something wrong while invoking service...";
            result = new ClientException(message);
        }
        return result;
    }

    protected Map<QName, String> getAddressing(Message message) {
        Map props;
        HashMap<QName, String> result = new HashMap<QName, String>();
        if (message != null && message.getProperties() != null && (props = message.getProperties()).get(Constants.WSStar.Addressing.TO_QNAME.toString()) != null) {
            result.put(Constants.WSStar.Addressing.TO_QNAME, (String)props.get(Constants.WSStar.Addressing.TO_QNAME.toString()));
        }
        return result;
    }
}

