/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easybox.impl;

import com.ebmwebsourcing.easybox.api.ModelObject;
import com.ebmwebsourcing.easybox.impl.DomModelObject;
import com.ebmwebsourcing.easybox.impl.TextModelObject;
import com.ebmwebsourcing.easycommons.lang.UncheckedException;
import javax.xml.bind.JAXBElement;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

final class ModelObjectFactory {
    private static final String MODEL_OBJECT_USERDATA_KEY = "modelObject";

    ModelObjectFactory() {
    }

    static ModelObject createModelObject(ModelObject parent, Object obj) {
        assert (obj != null);
        if (obj instanceof ModelObject) {
            return (ModelObject)obj;
        }
        if (obj instanceof JAXBElement) {
            JAXBElement jaxbElement = (JAXBElement)obj;
            if (jaxbElement.getValue() == null) {
                return null;
            }
            return ModelObjectFactory.createModelObject(parent, jaxbElement.getValue());
        }
        if (obj instanceof Text) {
            Text textNode = (Text)obj;
            ModelObject parentModelObject = ModelObjectFactory.createModelObject(null, textNode.getParentNode());
            return ModelObjectFactory.createModelObject(parentModelObject, textNode.getNodeValue());
        }
        if (obj instanceof String) {
            String s = (String)obj;
            if (s.trim().isEmpty()) {
                return null;
            }
            return new TextModelObject(parent, s);
        }
        if (obj instanceof Element) {
            Element element = (Element)obj;
            Object userData = element.getUserData(MODEL_OBJECT_USERDATA_KEY);
            if (userData != null) {
                return (ModelObject)userData;
            }
            DomModelObject modelObject = new DomModelObject(parent, (Element)obj);
            element.setUserData(MODEL_OBJECT_USERDATA_KEY, modelObject, null);
            return modelObject;
        }
        throw new UncheckedException(String.format("Cannot create model object for obj of type '%s'.", obj.getClass()));
    }
}

