/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.component.framework.util;

import java.io.File;
import java.io.FileFilter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.util.ArrayList;
import org.ow2.petals.component.framework.util.ComponentPrivilegedAction;

public final class ClassLoaderUtil {
    private ClassLoaderUtil() {
    }

    public static URL[] getUrls(String directoryName) {
        File path = new File(directoryName);
        FileFilter jarFileFilter = new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.getName().toLowerCase().endsWith(".jar");
            }
        };
        File[] files = path.listFiles(jarFileFilter);
        ArrayList<URL> urls = new ArrayList<URL>();
        if (files != null && files.length > 0) {
            for (File file : files) {
                try {
                    urls.add(file.toURI().toURL());
                }
                catch (MalformedURLException e) {
                    // empty catch block
                }
            }
        }
        return urls.toArray(new URL[urls.size()]);
    }

    public static URLClassLoader createClassLoader(String rootPath, ClassLoader parent) {
        return AccessController.doPrivileged(new ComponentPrivilegedAction(rootPath, parent));
    }
}

