/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.component.framework.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.ow2.petals.commons.threadlocal.DocumentBuilders;
import org.ow2.petals.commons.threadlocal.Transformers;
import org.ow2.petals.component.framework.util.StringHelper;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class XMLUtil {
    private static final Logger LOGGER = Logger.getLogger(XMLUtil.class.getName());

    private XMLUtil() {
    }

    public static Node createAttribute(Document document, String att, String value) {
        Attr element = null;
        if (document != null) {
            element = document.createAttribute(att);
            element.setNodeValue(value);
        }
        return element;
    }

    public static Node createNode(Document document, String nodeName, String ... attVal) {
        Element element = null;
        if (document != null && attVal.length % 2 == 0) {
            element = document.createElement(nodeName);
            for (int i = 0; i < attVal.length; i += 2) {
                element.getAttributes().setNamedItem(XMLUtil.createAttribute(document, attVal[i], attVal[i + 1]));
            }
        }
        return element;
    }

    private static Node lookupNodeInNodeList(String nodeName, String namespace, NodeList nl) {
        Node result = null;
        Node tmp = null;
        for (int i = 0; i < nl.getLength() && result == null; ++i) {
            tmp = nl.item(i);
            if (namespace != null && tmp.getNamespaceURI() != null && tmp.getNamespaceURI().equals(namespace) && nodeName.equals(tmp.getLocalName())) {
                result = tmp;
                continue;
            }
            if (nodeName.equals(tmp.getLocalName())) {
                result = tmp;
                continue;
            }
            if (!nodeName.equals(tmp.getNodeName())) continue;
            result = tmp;
        }
        return result;
    }

    public static Node findChild(Node node, String nodeName, String namespaceURI, boolean recursive) {
        Node result = null;
        if (node != null && nodeName != null) {
            node.normalize();
            NodeList nl = node.getChildNodes();
            result = XMLUtil.lookupNodeInNodeList(nodeName, namespaceURI, nl);
            if (result == null && recursive) {
                for (int i = 0; i < nl.getLength() && result == null; ++i) {
                    result = XMLUtil.findChild(nl.item(i), nodeName, namespaceURI, true);
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String parseToString(Node node) throws TransformerException {
        String result = null;
        if (node != null) {
            node.normalize();
            StringWriter stringWriter = new StringWriter();
            Transformer transformer = Transformers.getXmlWithDeclarationTransformer();
            try {
                transformer.transform(new DOMSource(node), new StreamResult(stringWriter));
                Object var5_4 = null;
                transformer.reset();
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                transformer.reset();
                throw throwable;
            }
            StringBuffer buffer = stringWriter.getBuffer();
            result = buffer.toString();
        }
        return result;
    }

    public static String getAttributeValue(Node n, String attName) {
        NamedNodeMap atts;
        Node att;
        String ret = null;
        if (n != null && (att = (atts = n.getAttributes()).getNamedItem(attName)) != null) {
            ret = att.getNodeValue();
        }
        return ret;
    }

    public static String getRequiredAttributeValue(Node n, String attName) {
        String ret = null;
        if (n != null && !StringHelper.isNullOrEmpty(attName)) {
            NamedNodeMap atts = n.getAttributes();
            Node att = atts.getNamedItem(attName);
            if (att == null) {
                throw new NullPointerException("Required attribute '" + attName + "' not found in the node.");
            }
            ret = att.getNodeValue();
        }
        return ret;
    }

    public static Node getFirstChild(Node node) {
        Node result;
        for (result = node.getFirstChild(); result != null && (result.getNodeType() == 3 || result.getNodeType() == 4); result = result.getNextSibling()) {
        }
        return result;
    }

    public static Node getNextSibling(Node node) {
        Node result = null;
        if (node != null) {
            for (result = node.getNextSibling(); result != null && (result.getNodeType() == 3 || result.getNodeType() == 4); result = result.getNextSibling()) {
            }
        }
        return result;
    }

    public static String getTextContent(Node node) {
        String result = null;
        NodeList list = node.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            String cdataContent;
            Node currentNode = list.item(i);
            if (currentNode.getNodeType() != 3 && currentNode.getNodeType() != 4) continue;
            result = currentNode.getNodeValue();
            Node nextSiblingNode = currentNode.getNextSibling();
            if (nextSiblingNode != null && nextSiblingNode.getNodeType() == 4 && (cdataContent = nextSiblingNode.getNodeValue()) != null) {
                result = result + cdataContent;
            }
            result = result.replace('\t', ' ').replace('\n', ' ').trim();
            break;
        }
        return result;
    }

    public static String createStringFromDOMDocument(Node document) throws TransformerException {
        return XMLUtil.createStringFromDOMNode(document, false);
    }

    public static String createStringFromDOMNode(Node node) throws TransformerException {
        return XMLUtil.createStringFromDOMNode(node, true);
    }

    public static String createStringFromDOMNodeList(NodeList list) throws TransformerException {
        StringBuffer sb = new StringBuffer("");
        if (list != null) {
            for (int i = 0; i < list.getLength(); ++i) {
                sb.append(XMLUtil.createStringFromDOMNode(list.item(i)));
            }
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String createStringFromDOMNode(Node node, boolean omitDeclaration) throws TransformerException {
        node.normalize();
        DOMSource source = new DOMSource(node);
        StringWriter out = new StringWriter();
        StreamResult resultStream = new StreamResult(out);
        Transformer transformer = omitDeclaration ? Transformers.getXmlWithoutDeclarationTransformer() : Transformers.getXmlWithDeclarationTransformer();
        try {
            transformer.transform(source, resultStream);
            Object var7_6 = null;
            transformer.reset();
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            transformer.reset();
            throw throwable;
        }
        return out.toString();
    }

    public static Document createDocumentFromString(String xml) {
        Document doc = null;
        try {
            ByteArrayInputStream in = new ByteArrayInputStream(xml.getBytes());
            InputSource inputSource = new InputSource(in);
            doc = DocumentBuilders.getNamespaceDocumentBuilder().parse(inputSource);
            doc.normalize();
        }
        catch (SAXException e) {
            LOGGER.log(Level.SEVERE, "Bad XML fragment can't be transformed to a DOM tree.", e);
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Unexpected Error", e);
        }
        return doc;
    }

    public static List<String> getTextContents(NodeList list) {
        ArrayList<String> result = null;
        if (list != null) {
            result = new ArrayList<String>();
            for (int i = 0; i < list.getLength(); ++i) {
                Node pathElement = list.item(i);
                if (pathElement.getNodeType() == 3) continue;
                result.add(XMLUtil.getTextContent(pathElement));
            }
        }
        return result;
    }

    public static QName extractXmlAttributeQName(Node node, String attrName) {
        String attr = XMLUtil.getAttributeValue(node, attrName);
        QName qName = null;
        if (attr != null) {
            if (attr.indexOf(58) > -1 && attr.charAt(0) != '{') {
                String ns = attr.substring(0, attr.indexOf(58));
                String namespace = node.lookupNamespaceURI(ns);
                qName = new QName(namespace, attr.substring(attr.indexOf(58) + 1), ns);
            } else {
                qName = QName.valueOf(attr);
            }
        }
        return qName;
    }

    public static QName extractRequiredXmlAttributeQName(Node node, String attrName) {
        String attr = XMLUtil.getRequiredAttributeValue(node, attrName);
        QName qName = null;
        if (attr.indexOf(58) > -1 && attr.charAt(0) != '{') {
            String ns = attr.substring(0, attr.indexOf(58));
            String namespace = node.lookupNamespaceURI(ns);
            qName = new QName(namespace, attr.substring(attr.indexOf(58) + 1), ns);
        } else {
            qName = QName.valueOf(attr);
        }
        return qName;
    }

    public static List<Node> getNodeChildren(Node node) {
        ArrayList<Node> children = new ArrayList<Node>();
        if (node != null) {
            NodeList childrenList = node.getChildNodes();
            for (int i = 0; i < childrenList.getLength(); ++i) {
                Node child = childrenList.item(i);
                if (child.getNodeType() != 1) continue;
                children.add(child);
            }
        }
        return children;
    }

    public static Node getNode(Document document, String elementName) {
        NodeList resList;
        Node result = null;
        if (document != null && elementName != null && (resList = document.getElementsByTagName(elementName)) != null && resList.getLength() > 0) {
            return resList.item(0);
        }
        return result;
    }

    public static Node getNodeWithAttribute(Document document, String elementName, String attributeName, String attributeValue) {
        Element result = null;
        if (document != null && elementName != null && attributeName != null && attributeValue != null) {
            NodeList resList = document.getElementsByTagName(elementName);
            for (int i = 0; i < resList.getLength() && result == null; ++i) {
                Element curNode = (Element)resList.item(i);
                if (!attributeValue.equals(curNode.getAttribute(attributeName))) continue;
                result = curNode;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeDocument(Document document, OutputStream outputStream) throws Exception {
        if (document != null && outputStream != null) {
            Transformer transformer = Transformers.getXmlWithDeclarationTransformer();
            try {
                transformer.transform(new DOMSource(document), new StreamResult(outputStream));
                Object var4_3 = null;
                transformer.reset();
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                transformer.reset();
                throw throwable;
            }
        } else {
            throw new Exception("Can not write document to output stream");
        }
    }

    public static Document loadDocument(InputStream inputStream) throws IOException, SAXException {
        Document document = null;
        try {
            document = DocumentBuilders.getNamespaceDocumentBuilder().parse(inputStream);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return document;
    }

    public static Document createDocument() {
        return DocumentBuilders.getNamespaceDocumentBuilder().newDocument();
    }
}

