/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.dsb.jbi.se.wsn;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import javax.jbi.JBIException;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.xml.namespace.QName;
import org.ow2.easywsdl.wsdl.api.Endpoint;
import org.ow2.easywsdl.wsdl.api.Service;
import org.ow2.easywsdl.wsdl.api.WSDLException;
import org.ow2.petals.component.framework.PetalsBindingComponent;
import org.ow2.petals.component.framework.api.Wsdl;
import org.ow2.petals.component.framework.util.ServiceEndpointKey;
import org.ow2.petals.component.framework.util.UtilFactory;
import org.petalslink.dsb.jbi.se.wsn.NotificationEngine;
import org.w3c.dom.Document;

public class Component
extends PetalsBindingComponent {
    public static final String FILE_CFG = "notification.cfg";
    public static final String TOPICS_NS_FILE = "topics.xml";
    private static final String ENDPOINT_NAME = "endpoint";
    private static final String INTERFACE_NAME = "interface";
    private static final String SERVICE_NAME = "service";
    private static final String SUPPORTED_TOPICS = "supported-topics";
    NotificationEngine engine;
    private Map<ServiceEndpointKey, Wsdl> WSNEP;

    protected void postDoInit() throws JBIException {
        String[] topics;
        this.WSNEP = new ConcurrentHashMap<ServiceEndpointKey, Wsdl>();
        Properties props = new Properties();
        try {
            props.load(Component.class.getClassLoader().getResourceAsStream(FILE_CFG));
        }
        catch (IOException e) {
            throw new JBIException("Can not find the notification configuration file");
        }
        URL url = Component.class.getClassLoader().getResource(TOPICS_NS_FILE);
        if (url == null) {
            throw new JBIException("Can not find the notification topics configuration file");
        }
        String endpointName = props.getProperty(ENDPOINT_NAME);
        QName interfaceName = QName.valueOf(props.getProperty(INTERFACE_NAME));
        QName serviceName = QName.valueOf(props.getProperty(SERVICE_NAME));
        String tmp = props.getProperty(SUPPORTED_TOPICS);
        ArrayList<String> supportedTopics = new ArrayList<String>();
        if (tmp != null && (topics = (tmp = tmp.trim()).split(",")) != null) {
            String[] stringArray = topics;
            int n = topics.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray[n2];
                if (string.trim().length() > 0) {
                    supportedTopics.add(string.trim());
                }
                ++n2;
            }
        }
        if (this.engine == null) {
            this.engine = new NotificationEngine(this.getLogger(), url, supportedTopics, serviceName, interfaceName, endpointName, this.getJBIClient());
        }
        this.engine.init();
    }

    protected void doStart() throws JBIException {
        this.activateWSNEndpoints();
    }

    private void activateWSNEndpoints() throws JBIException {
        List endpointList = null;
        QName serviceName = null;
        String endpointName = null;
        try {
            Endpoint endpoint;
            Iterator iterator;
            endpointList = UtilFactory.getWSDLUtil().getEndpointList(this.engine.getProducerWSDL().getDescription());
            if (endpointList != null && (iterator = endpointList.iterator()) != null) {
                while (iterator.hasNext()) {
                    endpoint = (Endpoint)iterator.next();
                    if (endpoint == null) continue;
                    serviceName = ((Service)endpoint.getService()).getQName();
                    endpointName = endpoint.getName();
                    this.activateWSNEndpoint(serviceName, endpointName, this.engine.getProducerWSDL());
                }
            }
            if ((endpointList = UtilFactory.getWSDLUtil().getEndpointList(this.engine.getConsumerWSDL().getDescription())) != null && (iterator = endpointList.iterator()) != null) {
                while (iterator.hasNext()) {
                    endpoint = (Endpoint)iterator.next();
                    if (endpoint == null) continue;
                    serviceName = ((Service)endpoint.getService()).getQName();
                    endpointName = endpoint.getName();
                    this.activateWSNEndpoint(serviceName, endpointName, this.engine.getConsumerWSDL());
                }
            }
        }
        catch (WSDLException e) {
            e.printStackTrace();
        }
    }

    private void activateWSNEndpoint(QName serviceName, String endpointName, Wsdl wsdl) throws JBIException {
        this.WSNEP.put(new ServiceEndpointKey(serviceName, endpointName), wsdl);
        ServiceEndpoint se = null;
        try {
            se = this.context.activateEndpoint(serviceName, endpointName);
        }
        catch (Exception e) {
            this.WSNEP.remove(new ServiceEndpointKey(serviceName, endpointName));
        }
    }

    protected void doStop() throws JBIException {
    }

    protected void doShutdown() throws JBIException {
    }

    public Document getServiceDescription(ServiceEndpoint endpoint) {
        if (endpoint == null) {
            return null;
        }
        if (this.isNotification(endpoint)) {
            return this.getWSNDescription(endpoint);
        }
        return super.getServiceDescription(endpoint);
    }

    private Document getWSNDescription(ServiceEndpoint endpoint) {
        Wsdl desc = this.WSNEP.get(new ServiceEndpointKey(endpoint.getServiceName(), endpoint.getEndpointName()));
        if (desc != null) {
            return desc.getDocument();
        }
        return null;
    }

    public NotificationEngine getNotificationEngine() {
        return this.engine;
    }

    private boolean isNotification(ServiceEndpoint endpoint) {
        return this.WSNEP.get(new ServiceEndpointKey(endpoint.getServiceName(), endpoint.getEndpointName())) != null;
    }
}

