/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.dsb.jbi.se.wsn.listeners;

import com.ebmwebsourcing.easycommons.xml.XMLHelper;
import com.ebmwebsourcing.wsaddressing10.api.element.Address;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.NotificationMessageHolderType;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.Notify;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.Subscribe;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.SubscribeResponse;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.Unsubscribe;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.UnsubscribeResponse;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.refinedabstraction.RefinedWsnbFactory;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.utils.WsnbException;
import com.ebmwebsourcing.wsstar.resourceproperties.datatypes.api.abstraction.GetResourcePropertyResponse;
import com.ebmwebsourcing.wsstar.resourceproperties.datatypes.api.refinedabstraction.RefinedWsrfrpFactory;
import com.ebmwebsourcing.wsstar.resourceproperties.datatypes.api.utils.WsrfrpException;
import com.ebmwebsourcing.wsstar.wsnb.services.impl.util.Wsnb4ServUtils;
import com.ebmwebsourcing.wsstar.wsrfbf.services.faults.AbsWSStarFault;
import java.net.URI;
import java.util.List;
import java.util.logging.Level;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import org.ow2.petals.component.framework.api.exception.PEtALSCDKException;
import org.ow2.petals.component.framework.api.message.Exchange;
import org.ow2.petals.component.framework.listener.AbstractJBIListener;
import org.ow2.petals.component.framework.util.UtilFactory;
import org.petalslink.dsb.jbi.se.wsn.AddressingHelper;
import org.petalslink.dsb.jbi.se.wsn.Component;
import org.petalslink.dsb.jbi.se.wsn.NotificationEngine;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public abstract class NotificationV2JBIListener
extends AbstractJBIListener {
    static final String LOCATION_COMPONENT = "consumer.location.component";
    static final String LOCATION_CONTAINER = "consumer.location.container";
    static final String LOCATION_DOMAIN = "consumer.location.domain";

    public boolean onNotificationMessage(Exchange exchange) {
        boolean response;
        block29: {
            System.out.println(String.format("We have a notification message with operation '%s'", exchange.getOperation()));
            NotificationEngine engine = this.getNotificationEngine();
            response = true;
            NormalizedMessage normalizedMessage = null;
            Document document = null;
            Address address = null;
            try {
                if (this.getLogger().isLoggable(Level.FINE)) {
                    QName[] qNameArray = exchange.getEndpoint().getInterfaces();
                    int n = qNameArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        QName intf = qNameArray[n2];
                        this.getLogger().fine("notification endpoint interface: " + intf);
                        ++n2;
                    }
                    this.getLogger().fine("notification endpoint service: " + exchange.getEndpoint().getServiceName());
                    this.getLogger().fine("notification endpoint name: " + exchange.getEndpoint().getEndpointName());
                    this.getLogger().fine("notification operation name: " + exchange.getOperationName());
                }
                if (!exchange.isActiveStatus()) break block29;
                if (exchange.getFault() != null) {
                    if (this.getLogger().isLoggable(Level.WARNING)) {
                        if (UtilFactory.getExchangeUtil().isPetalsException(exchange.getFault())) {
                            this.getLogger().warning("notification technical fault message content: " + UtilFactory.getSourceUtil().createString(exchange.getFault().getContent()));
                        } else {
                            this.getLogger().warning("notification business fault message content: " + UtilFactory.getSourceUtil().createString(exchange.getFault().getContent()));
                        }
                    }
                    break block29;
                }
                normalizedMessage = exchange.getInMessage();
                if ("Subscribe".equals(exchange.getOperation().getLocalPart())) {
                    String domain;
                    document = UtilFactory.getSourceUtil().createDocument(normalizedMessage.getContent());
                    Subscribe subscribe = RefinedWsnbFactory.getInstance().getWsnbReader().readSubscribe(document);
                    Address consumerAddress = subscribe.getConsumerReference().getAddress();
                    URI value = consumerAddress.getValue();
                    this.getLogger().log(Level.FINE, String.format("Initial address is '%s'", value));
                    String component = exchange.getProperty(LOCATION_COMPONENT) != null ? exchange.getProperty(LOCATION_COMPONENT).toString() : null;
                    String container = exchange.getProperty(LOCATION_CONTAINER) != null ? exchange.getProperty(LOCATION_CONTAINER).toString() : null;
                    String string = domain = exchange.getProperty(LOCATION_DOMAIN) != null ? exchange.getProperty(LOCATION_DOMAIN).toString() : null;
                    if (this.getLogger().isLoggable(Level.FINE)) {
                        this.getLogger().log(Level.FINE, String.format("Source location is component='%s' container='%s' domain='%s'", component, container, domain));
                    }
                    Document dom = Wsnb4ServUtils.getWsnbWriter().writeSubscribeAsDOM(subscribe);
                    try {
                        System.out.println(XMLHelper.createStringFromDOMDocument((Node)dom));
                    }
                    catch (TransformerException transformerException) {
                        // empty catch block
                    }
                    SubscribeResponse subscribeResponse = engine.getNotificationManager().getNotificationProducerEngine().subscribe(subscribe);
                    document = RefinedWsnbFactory.getInstance().getWsnbWriter().writeSubscribeResponseAsDOM(subscribeResponse);
                    normalizedMessage = exchange.getOutMessage();
                    normalizedMessage.setContent((Source)UtilFactory.getSourceUtil().createStreamSource(document));
                    exchange.setOutMessage(normalizedMessage);
                    break block29;
                }
                if ("Notify".equals(exchange.getOperation().getLocalPart())) {
                    document = UtilFactory.getSourceUtil().createDocument(normalizedMessage.getContent());
                    Notify notify = RefinedWsnbFactory.getInstance().getWsnbReader().readNotify(document);
                    List notificationMessageList = notify.getNotificationMessage();
                    if (notificationMessageList == null || notificationMessageList.size() != 1) {
                        exchange.setError(new Exception("The CDK need one and only one notification message"));
                    } else if (((NotificationMessageHolderType)notificationMessageList.get(0)).getSubscriptionReference() != null) {
                        address = ((NotificationMessageHolderType)notificationMessageList.get(0)).getSubscriptionReference().getAddress();
                    }
                    engine.getNotificationConsumerEngine().notify(notify);
                } else if ("Unsubscribe".equals(exchange.getOperation().getLocalPart())) {
                    document = UtilFactory.getSourceUtil().createDocument(normalizedMessage.getContent());
                    Unsubscribe unsubscribe = RefinedWsnbFactory.getInstance().getWsnbReader().readUnsubscribe(document);
                    UnsubscribeResponse unsubscribeResponse = engine.getNotificationManager().getSubscriptionManagerEngine().unsubscribe(unsubscribe);
                    document = RefinedWsnbFactory.getInstance().getWsnbWriter().writeUnsubscribeResponseAsDOM(unsubscribeResponse);
                    normalizedMessage = exchange.getOutMessage();
                    normalizedMessage.setContent((Source)UtilFactory.getSourceUtil().createStreamSource(document));
                    exchange.setOutMessage(normalizedMessage);
                } else if ("GetCurrentMessage".equals(exchange.getOperation().getLocalPart())) {
                    System.out.println("TODO");
                } else if ("Renew".equals(exchange.getOperation().getLocalPart())) {
                    System.out.println("TODO");
                } else if ("GetResourceProperty".equals(exchange.getOperation().getLocalPart())) {
                    document = UtilFactory.getSourceUtil().createDocument(normalizedMessage.getContent());
                    QName qname = RefinedWsrfrpFactory.getInstance().getWsrfrpReader().readGetResourceProperty(document);
                    GetResourcePropertyResponse res = engine.getNotificationManager().getNotificationProducerEngine().getResourceProperty(qname);
                    document = RefinedWsrfrpFactory.getInstance().getWsrfrpWriter().writeGetResourcePropertyResponseAsDOM(res);
                    normalizedMessage = exchange.getOutMessage();
                    normalizedMessage.setContent((Source)UtilFactory.getSourceUtil().createStreamSource(document));
                    exchange.setOutMessage(normalizedMessage);
                } else {
                    exchange.setError(new Exception(String.format("unable to identify the operation %s of the WS-Notification specifications, or not implemented", exchange.getOperation())));
                }
            }
            catch (PEtALSCDKException e) {
                exchange.setError(new Exception(e));
            }
            catch (WsnbException e) {
                exchange.setError(new Exception(e));
            }
            catch (AbsWSStarFault e) {
                exchange.setError(new Exception(e));
            }
            catch (MessagingException e) {
                exchange.setError(new Exception(e));
            }
            catch (WsrfrpException e) {
                exchange.setError(new Exception(e));
            }
        }
        return response;
    }

    private void addLocation(Address address, String component, String container, String domain) {
        if (address == null) {
            return;
        }
        URI uri = address.getValue();
        if (AddressingHelper.isInternalService(uri)) {
            address.setValue(AddressingHelper.addLocation(uri, component, container, domain));
        } else if (AddressingHelper.isExternalService(uri)) {
            String tmp = uri.toString();
            if (!tmp.startsWith("http://dsb.petalslink.org/service/external/")) {
                tmp = "http://dsb.petalslink.org/service/external/::" + uri.toString();
            }
            address.setValue(AddressingHelper.addLocation(URI.create(tmp), component, container, domain));
        }
    }

    NotificationEngine getNotificationEngine() {
        return ((Component)this.getComponent()).getNotificationEngine();
    }

    public static void main(String[] args) {
        URI uri = URI.create("dsb://container/component/domain::http://foo/bar::dsb://domain=");
        System.out.println(uri);
    }
}

