/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.aegis.databinding;

import java.util.Collection;
import javax.xml.namespace.QName;
import javax.xml.validation.Schema;
import org.apache.cxf.aegis.AegisElementDataReader;
import org.apache.cxf.aegis.databinding.AegisDatabinding;
import org.apache.cxf.aegis.type.AegisType;
import org.apache.cxf.databinding.DataReader;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Attachment;
import org.apache.cxf.service.model.MessagePartInfo;
import org.w3c.dom.Element;

public class ElementDataReader
implements DataReader<Element> {
    private AegisElementDataReader reader;
    private AegisDatabinding databinding;

    ElementDataReader(AegisDatabinding binding) {
        this.databinding = binding;
        this.reader = new AegisElementDataReader(binding.getAegisContext());
    }

    @Override
    public Object read(Element input) {
        try {
            return this.reader.read(input);
        }
        catch (Exception e) {
            throw new Fault(e);
        }
    }

    @Override
    public Object read(MessagePartInfo part, Element input) {
        try {
            AegisType type = this.databinding.getType(part);
            return this.reader.read(input, type);
        }
        catch (Exception e) {
            throw new Fault(e);
        }
    }

    @Override
    public Object read(QName name, Element input, Class typeClass) {
        try {
            return this.reader.read(input);
        }
        catch (Exception e) {
            throw new Fault(e);
        }
    }

    @Override
    public void setAttachments(Collection<Attachment> attachments) {
        this.reader.getContext().setAttachments(attachments);
    }

    @Override
    public void setProperty(String prop, Object value) {
        this.reader.setProperty(prop, value);
    }

    @Override
    public void setSchema(Schema s) {
        this.reader.setSchema(s);
    }
}

