/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.bus.extension;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import org.apache.cxf.bus.extension.Extension;
import org.apache.cxf.bus.extension.ExtensionException;
import org.apache.cxf.staxutils.StaxUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ExtensionFragmentParser {
    private static final String EXTENSION_ELEM_NAME = "extension";
    private static final String NAMESPACE_ELEM_NAME = "namespace";
    private static final String CLASS_ATTR_NAME = "class";
    private static final String INTERFACE_ATTR_NAME = "interface";
    private static final String DEFERRED_ATTR_NAME = "deferred";

    List<Extension> getExtensionsFromXML(InputStream is) {
        Document document = null;
        try {
            document = StaxUtils.read(is);
        }
        catch (XMLStreamException ex) {
            throw new ExtensionException(ex);
        }
        return this.deserialiseExtensions(document);
    }

    List<Extension> getExtensionsFromText(InputStream is) throws IOException {
        ArrayList<Extension> extensions = new ArrayList<Extension>();
        BufferedReader reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
        String line = reader.readLine();
        while (line != null) {
            Extension extension = this.getExtensionFromTextLine(line);
            if (extension != null) {
                extensions.add(extension);
            }
            line = reader.readLine();
        }
        return extensions;
    }

    private Extension getExtensionFromTextLine(String line) {
        if ((line = line.trim()).length() == 0 || line.charAt(0) == '#') {
            return null;
        }
        Extension ext = new Extension();
        String[] parts = line.split(":");
        ext.setClassname(parts[0]);
        if (ext.getClassname() == null) {
            return null;
        }
        if (parts.length >= 2) {
            String interfaceName = parts[1];
            if (interfaceName != null && "".equals(interfaceName)) {
                interfaceName = null;
            }
            ext.setInterfaceName(interfaceName);
        }
        if (parts.length >= 3) {
            ext.setDeferred(Boolean.parseBoolean(parts[2]));
        }
        return ext;
    }

    List<Extension> deserialiseExtensions(Document document) {
        ArrayList<Extension> extensions = new ArrayList<Extension>();
        Element root = document.getDocumentElement();
        for (Node nd = root.getFirstChild(); nd != null; nd = nd.getNextSibling()) {
            if (1 != nd.getNodeType() || !EXTENSION_ELEM_NAME.equals(nd.getLocalName())) continue;
            Extension e = new Extension();
            Element elem = (Element)nd;
            e.setClassname(elem.getAttribute(CLASS_ATTR_NAME));
            e.setInterfaceName(elem.getAttribute(INTERFACE_ATTR_NAME));
            String bval = elem.getAttribute(DEFERRED_ATTR_NAME).trim();
            e.setDeferred("1".equals(bval) || "true".equals(bval));
            this.deserialiseNamespaces(elem, e);
            extensions.add(e);
        }
        return extensions;
    }

    void deserialiseNamespaces(Element extensionElem, Extension e) {
        for (Node nd = extensionElem.getFirstChild(); nd != null; nd = nd.getNextSibling()) {
            if (1 != nd.getNodeType() || !NAMESPACE_ELEM_NAME.equals(nd.getLocalName())) continue;
            e.getNamespaces().add(nd.getTextContent());
        }
    }
}

