/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.client;

import java.net.URI;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.apache.cxf.jaxrs.client.ClientState;
import org.apache.cxf.jaxrs.client.LocalClientState;

public class ThreadLocalClientState
implements ClientState {
    private Map<Thread, LocalClientState> state = Collections.synchronizedMap(new WeakHashMap());
    private LocalClientState initialState;
    private Map<Thread, Long> checkpointMap;
    private long secondsToKeepState;

    public ThreadLocalClientState(String baseURI) {
        this.initialState = new LocalClientState(URI.create(baseURI));
    }

    public ThreadLocalClientState(LocalClientState initialState) {
        this.initialState = initialState;
    }

    @Override
    public void setCurrentBuilder(UriBuilder currentBuilder) {
        this.getState().setCurrentBuilder(currentBuilder);
    }

    @Override
    public UriBuilder getCurrentBuilder() {
        return this.getState().getCurrentBuilder();
    }

    @Override
    public void setBaseURI(URI baseURI) {
        this.getState().setBaseURI(baseURI);
    }

    @Override
    public URI getBaseURI() {
        return this.getState().getBaseURI();
    }

    @Override
    public void setResponseBuilder(Response.ResponseBuilder responseBuilder) {
        this.getState().setResponseBuilder(responseBuilder);
    }

    @Override
    public Response.ResponseBuilder getResponseBuilder() {
        return this.getState().getResponseBuilder();
    }

    @Override
    public void setRequestHeaders(MultivaluedMap<String, String> requestHeaders) {
        this.getState().setRequestHeaders(requestHeaders);
    }

    @Override
    public MultivaluedMap<String, String> getRequestHeaders() {
        return this.getState().getRequestHeaders();
    }

    @Override
    public MultivaluedMap<String, String> getTemplates() {
        return this.getState().getTemplates();
    }

    @Override
    public void setTemplates(MultivaluedMap<String, String> map) {
        this.getState().setTemplates(map);
    }

    @Override
    public void reset() {
        this.removeThreadLocalState(Thread.currentThread());
    }

    @Override
    public ClientState newState(URI baseURI, MultivaluedMap<String, String> headers, MultivaluedMap<String, String> templates) {
        LocalClientState ls = new LocalClientState(baseURI);
        ls.setRequestHeaders(headers);
        ls.setTemplates(templates);
        return new ThreadLocalClientState(ls);
    }

    private void removeThreadLocalState(Thread t) {
        this.state.remove(t);
        if (this.checkpointMap != null) {
            this.checkpointMap.remove(t);
        }
    }

    protected ClientState getState() {
        LocalClientState cs = this.state.get(Thread.currentThread());
        if (cs == null) {
            cs = new LocalClientState(this.initialState);
            this.state.put(Thread.currentThread(), cs);
            if (this.secondsToKeepState > 0L) {
                long currentTime = System.currentTimeMillis();
                this.checkpointMap.put(Thread.currentThread(), currentTime);
                new CleanupThread(Thread.currentThread(), currentTime).start();
            }
        }
        return cs;
    }

    public void setSecondsToKeepState(long secondsToKeepState) {
        this.secondsToKeepState = secondsToKeepState;
        if (secondsToKeepState > 0L) {
            this.checkpointMap = new ConcurrentHashMap<Thread, Long>();
        }
    }

    private class CleanupThread
    extends Thread {
        private Thread thread;
        private long originalTime;

        public CleanupThread(Thread thread, long originalTime) {
            this.thread = thread;
            this.originalTime = originalTime;
        }

        @Override
        public void run() {
            try {
                Thread.sleep(ThreadLocalClientState.this.secondsToKeepState);
                long actualTime = (Long)ThreadLocalClientState.this.checkpointMap.get(this.thread);
                if (actualTime == this.originalTime) {
                    ThreadLocalClientState.this.removeThreadLocalState(this.thread);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

