/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.ext.search.client;

import java.text.DateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import javax.xml.datatype.Duration;
import org.apache.cxf.jaxrs.ext.search.SearchUtils;
import org.apache.cxf.jaxrs.ext.search.client.CompleteCondition;
import org.apache.cxf.jaxrs.ext.search.client.PartialCondition;
import org.apache.cxf.jaxrs.ext.search.client.Property;
import org.apache.cxf.jaxrs.ext.search.client.SearchConditionBuilder;

public class FiqlSearchConditionBuilder
extends SearchConditionBuilder {
    private Map<String, String> properties;

    public FiqlSearchConditionBuilder() {
        this(Collections.emptyMap());
    }

    public FiqlSearchConditionBuilder(Map<String, String> properties) {
        this.properties = properties;
    }

    @Override
    public String query() {
        return "";
    }

    @Override
    public Property is(String property) {
        return new Builder(this.properties).is(property);
    }

    @Override
    public CompleteCondition and(CompleteCondition c1, CompleteCondition c2, CompleteCondition ... cn) {
        return new Builder(this.properties).and(c1, c2, cn);
    }

    @Override
    public CompleteCondition or(CompleteCondition c1, CompleteCondition c2, CompleteCondition ... cn) {
        return new Builder(this.properties).or(c1, c2, cn);
    }

    private static class Builder
    implements Property,
    CompleteCondition,
    PartialCondition {
        private String result = "";
        private Builder parent;
        private DateFormat df;
        private boolean timeZoneSupported;

        public Builder(Map<String, String> properties) {
            this.parent = null;
            this.df = SearchUtils.getDateFormat(properties, "yyyy-MM-dd'T'HH:mm:ss.SSSZ");
            this.timeZoneSupported = SearchUtils.isTimeZoneSupported(properties, Boolean.TRUE);
        }

        public Builder(Builder parent) {
            this.parent = parent;
            this.df = parent.getDateFormat();
            this.timeZoneSupported = parent.isTimeZoneSupported();
        }

        @Override
        public String query() {
            return this.buildPartial(null);
        }

        private DateFormat getDateFormat() {
            return this.df;
        }

        private boolean isTimeZoneSupported() {
            return this.timeZoneSupported;
        }

        private String buildPartial(Builder exclude) {
            if (this.parent != null && !this.parent.equals(exclude)) {
                return this.parent.buildPartial(exclude) + this.result;
            }
            return this.result;
        }

        @Override
        public CompleteCondition after(Date date) {
            this.result = this.result + "=gt=" + this.toString(date);
            return this;
        }

        @Override
        public CompleteCondition before(Date date) {
            this.result = this.result + "=lt=" + this.toString(date);
            return this;
        }

        @Override
        public CompleteCondition equalTo(String literalOrPattern) {
            this.result = this.result + "==" + literalOrPattern;
            return this;
        }

        @Override
        public CompleteCondition equalTo(double number) {
            this.result = this.result + "==" + number;
            return this;
        }

        @Override
        public CompleteCondition equalTo(Date date) {
            this.result = this.result + "==" + this.toString(date);
            return this;
        }

        @Override
        public CompleteCondition greaterOrEqualTo(double number) {
            this.result = this.result + "=ge=" + number;
            return this;
        }

        @Override
        public CompleteCondition greaterThan(double number) {
            this.result = this.result + "=gt=" + number;
            return this;
        }

        @Override
        public CompleteCondition lessOrEqualTo(double number) {
            this.result = this.result + "=le=" + number;
            return this;
        }

        @Override
        public CompleteCondition lessThan(double number) {
            this.result = this.result + "=lt=" + number;
            return this;
        }

        @Override
        public CompleteCondition lexicalAfter(String literal) {
            this.result = this.result + "=gt=" + literal;
            return this;
        }

        @Override
        public CompleteCondition lexicalBefore(String literal) {
            this.result = this.result + "=lt=" + literal;
            return this;
        }

        @Override
        public CompleteCondition lexicalNotAfter(String literal) {
            this.result = this.result + "=le=" + literal;
            return this;
        }

        @Override
        public CompleteCondition lexicalNotBefore(String literal) {
            this.result = this.result + "=ge=" + literal;
            return this;
        }

        @Override
        public CompleteCondition notAfter(Date date) {
            this.result = this.result + "=le=" + this.toString(date);
            return this;
        }

        @Override
        public CompleteCondition notBefore(Date date) {
            this.result = this.result + "=ge=" + this.toString(date);
            return this;
        }

        @Override
        public CompleteCondition notEqualTo(String literalOrPattern) {
            this.result = this.result + "!=" + literalOrPattern;
            return this;
        }

        @Override
        public CompleteCondition notEqualTo(double number) {
            this.result = this.result + "!=" + number;
            return this;
        }

        @Override
        public CompleteCondition notEqualTo(Date date) {
            this.result = this.result + "!=" + this.toString(date);
            return this;
        }

        @Override
        public CompleteCondition after(Duration distanceFromNow) {
            this.result = this.result + "=gt=" + distanceFromNow;
            return this;
        }

        @Override
        public CompleteCondition before(Duration distanceFromNow) {
            this.result = this.result + "=lt=" + distanceFromNow;
            return this;
        }

        @Override
        public CompleteCondition equalTo(Duration distanceFromNow) {
            this.result = this.result + "==" + distanceFromNow;
            return this;
        }

        @Override
        public CompleteCondition notAfter(Duration distanceFromNow) {
            this.result = this.result + "=le=" + distanceFromNow;
            return this;
        }

        @Override
        public CompleteCondition notBefore(Duration distanceFromNow) {
            this.result = this.result + "=ge=" + distanceFromNow;
            return this;
        }

        @Override
        public CompleteCondition notEqualTo(Duration distanceFromNow) {
            this.result = this.result + "!=" + distanceFromNow;
            return this;
        }

        @Override
        public PartialCondition and() {
            this.result = this.result + ";";
            return this;
        }

        @Override
        public PartialCondition or() {
            this.result = this.result + ",";
            return this;
        }

        @Override
        public CompleteCondition and(CompleteCondition c1, CompleteCondition c2, CompleteCondition ... cn) {
            this.result = this.result + "(" + ((Builder)c1).buildPartial(this) + ";" + ((Builder)c2).buildPartial(this);
            for (CompleteCondition c : cn) {
                this.result = this.result + ";" + ((Builder)c).buildPartial(this);
            }
            this.result = this.result + ")";
            return this;
        }

        @Override
        public CompleteCondition or(CompleteCondition c1, CompleteCondition c2, CompleteCondition ... cn) {
            this.result = this.result + "(" + ((Builder)c1).buildPartial(this) + "," + ((Builder)c2).buildPartial(this);
            for (CompleteCondition c : cn) {
                this.result = this.result + "," + ((Builder)c).buildPartial(this);
            }
            this.result = this.result + ")";
            return this;
        }

        @Override
        public Property is(String property) {
            Builder b = new Builder(this);
            b.result = property;
            return b;
        }

        private String toString(Date date) {
            String s = this.df.format(date);
            if (this.timeZoneSupported) {
                int len = s.length();
                return s.substring(0, len - 2) + ":" + s.substring(len - 2, len);
            }
            return s;
        }
    }
}

