/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.provider;

import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class PrefixCollectingXMLStreamWriter
implements XMLStreamWriter {
    private XMLStreamWriter target;
    private Map<String, String> namespaces;

    public PrefixCollectingXMLStreamWriter(XMLStreamWriter target, Map<String, String> namespaces) {
        this.target = target;
        this.namespaces = namespaces;
    }

    @Override
    public void close() throws XMLStreamException {
        this.target.close();
    }

    @Override
    public void flush() throws XMLStreamException {
        this.target.flush();
    }

    @Override
    public NamespaceContext getNamespaceContext() {
        return this.target.getNamespaceContext();
    }

    @Override
    public String getPrefix(String uri) throws XMLStreamException {
        return this.target.getPrefix(uri);
    }

    @Override
    public Object getProperty(String name) throws IllegalArgumentException {
        return this.target.getProperty(name);
    }

    @Override
    public void setDefaultNamespace(String uri) throws XMLStreamException {
        this.target.setDefaultNamespace(uri);
    }

    @Override
    public void setNamespaceContext(NamespaceContext context) throws XMLStreamException {
        this.target.setNamespaceContext(context);
    }

    @Override
    public void setPrefix(String prefix, String uri) throws XMLStreamException {
        String already = this.namespaces.get(uri);
        if (already != null && !prefix.equals(already)) {
            throw new RuntimeException("Reuse of prefix " + prefix);
        }
        this.namespaces.put(uri, prefix);
        this.target.setPrefix(prefix, uri);
    }

    @Override
    public void writeAttribute(String prefix, String namespaceURI, String localName, String value) throws XMLStreamException {
        this.target.writeAttribute(prefix, namespaceURI, localName, value);
    }

    @Override
    public void writeAttribute(String namespaceURI, String localName, String value) throws XMLStreamException {
        this.target.writeAttribute(namespaceURI, localName, value);
    }

    @Override
    public void writeAttribute(String localName, String value) throws XMLStreamException {
        this.target.writeAttribute(localName, value);
    }

    @Override
    public void writeCData(String data) throws XMLStreamException {
        this.target.writeCData(data);
    }

    @Override
    public void writeCharacters(char[] text, int start, int len) throws XMLStreamException {
        this.target.writeCharacters(text, start, len);
    }

    @Override
    public void writeCharacters(String text) throws XMLStreamException {
        this.target.writeCharacters(text);
    }

    @Override
    public void writeComment(String data) throws XMLStreamException {
        this.target.writeComment(data);
    }

    @Override
    public void writeDefaultNamespace(String namespaceURI) throws XMLStreamException {
        this.target.writeDefaultNamespace(namespaceURI);
    }

    @Override
    public void writeDTD(String dtd) throws XMLStreamException {
        this.target.writeDTD(dtd);
    }

    @Override
    public void writeEmptyElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
        this.target.writeEmptyElement(prefix, localName, namespaceURI);
    }

    @Override
    public void writeEmptyElement(String namespaceURI, String localName) throws XMLStreamException {
        this.target.writeEmptyElement(namespaceURI, localName);
    }

    @Override
    public void writeEmptyElement(String localName) throws XMLStreamException {
        this.target.writeEmptyElement(localName);
    }

    @Override
    public void writeEndDocument() throws XMLStreamException {
        this.target.writeEndDocument();
    }

    @Override
    public void writeEndElement() throws XMLStreamException {
        this.target.writeEndElement();
    }

    @Override
    public void writeEntityRef(String name) throws XMLStreamException {
        this.target.writeEntityRef(name);
    }

    @Override
    public void writeNamespace(String prefix, String namespaceURI) throws XMLStreamException {
        this.target.writeNamespace(prefix, namespaceURI);
    }

    @Override
    public void writeProcessingInstruction(String pitarget, String data) throws XMLStreamException {
        this.target.writeProcessingInstruction(pitarget, data);
    }

    @Override
    public void writeProcessingInstruction(String pitarget) throws XMLStreamException {
        this.target.writeProcessingInstruction(pitarget);
    }

    @Override
    public void writeStartDocument() throws XMLStreamException {
        this.target.writeStartDocument();
    }

    @Override
    public void writeStartDocument(String encoding, String version) throws XMLStreamException {
        this.target.writeStartDocument(encoding, version);
    }

    @Override
    public void writeStartDocument(String version) throws XMLStreamException {
        this.target.writeStartDocument(version);
    }

    @Override
    public void writeStartElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
        this.target.writeStartElement(prefix, localName, namespaceURI);
    }

    @Override
    public void writeStartElement(String namespaceURI, String localName) throws XMLStreamException {
        this.target.writeStartElement(namespaceURI, localName);
    }

    @Override
    public void writeStartElement(String localName) throws XMLStreamException {
        this.target.writeStartElement(localName);
    }
}

