/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.staxutils.transform;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;

class DelegatingNamespaceContext
implements NamespaceContext {
    private Map<String, String> prefixes = new HashMap<String, String>();
    private NamespaceContext nc;
    private Map<String, String> nsMap;

    public DelegatingNamespaceContext(NamespaceContext nc, Map<String, String> nsMap) {
        this.nc = nc;
        this.nsMap = nsMap;
    }

    public void addPrefix(String prefix, String namespace) {
        this.prefixes.put(namespace, prefix);
    }

    public String findUniquePrefix(String namespace) {
        if (namespace.length() == 0) {
            return null;
        }
        String existingPrefix = this.prefixes.get(namespace);
        if (existingPrefix != null) {
            return existingPrefix;
        }
        int i = 0;
        while (this.prefixes.containsKey("ps" + ++i)) {
        }
        String prefix = "ps" + i;
        this.addPrefix(prefix, namespace);
        return prefix;
    }

    @Override
    public String getNamespaceURI(String prefix) {
        for (Map.Entry<String, String> entry : this.prefixes.entrySet()) {
            if (!entry.getValue().equals(prefix)) continue;
            return entry.getKey();
        }
        String ns = this.nc.getNamespaceURI(prefix);
        this.addPrefix(prefix, ns);
        return ns;
    }

    @Override
    public String getPrefix(String ns) {
        String actualNs;
        if (ns.length() == 0) {
            return null;
        }
        String value = this.nsMap.get(ns);
        if (value != null && value.length() == 0) {
            return null;
        }
        String string = actualNs = value == null ? ns : value;
        if (this.prefixes.containsKey(actualNs)) {
            return this.prefixes.get(actualNs);
        }
        String prefix = this.nc.getPrefix(actualNs);
        this.addPrefix(prefix, actualNs);
        return prefix;
    }

    public Iterator getPrefixes(String ns) {
        return this.nc.getPrefixes(ns);
    }
}

