/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.rm;

import java.io.OutputStream;
import org.apache.cxf.interceptor.AttachmentOutInterceptor;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.StaxOutInterceptor;
import org.apache.cxf.io.WriteOnCloseOutputStream;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.ws.rm.RMManager;
import org.apache.cxf.ws.rm.RMUtils;
import org.apache.cxf.ws.rm.RetransmissionCallback;

public class RetransmissionInterceptor
extends AbstractPhaseInterceptor<Message> {
    RMManager manager;

    public RetransmissionInterceptor() {
        super("pre-stream");
        this.addBefore(StaxOutInterceptor.class.getName());
        this.addBefore(AttachmentOutInterceptor.class.getName());
    }

    public RMManager getManager() {
        return this.manager;
    }

    public void setManager(RMManager manager) {
        this.manager = manager;
    }

    @Override
    public void handleMessage(Message message) throws Fault {
        this.handle(message, false);
    }

    @Override
    public void handleFault(Message message) {
        this.handle(message, true);
    }

    void handle(Message message, boolean isFault) {
        if (null == this.getManager().getRetransmissionQueue()) {
            return;
        }
        OutputStream os = message.getContent(OutputStream.class);
        if (null == os) {
            return;
        }
        if (isFault) {
            message.setContent(Exception.class, null);
            message.getExchange().put(Exception.class, null);
        } else {
            WriteOnCloseOutputStream stream = RMUtils.createCachedStream(message, os);
            stream.registerCallback(new RetransmissionCallback(message, this.getManager()));
        }
    }
}

