/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.maven_plugin;

import java.io.File;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;

public class Option {
    static final String DEFAULT_BINDING_FILE_PATH = "src" + File.separator + "main" + File.separator + "resources" + File.separator + "defaultBinding.xml";
    private static final String DEFAULT_WSDL_LOCATION = "DEFAULTWSDLLOCATION - WORKAROUND";
    protected List<String> packagenames = new ArrayList<String>();
    protected List<String> extraargs = new ArrayList<String>();
    protected List<String> xjcargs = new ArrayList<String>();
    protected File outputDir;
    List<String> namespaceExcludes = new ArrayList<String>();
    Boolean defaultExcludesNamespace;
    Boolean defaultNamespacePackageMapping;
    File[] dependencies;
    File[] redundantDirs;
    String[] bindingFiles = new String[0];
    String wsdlLocation = "DEFAULTWSDLLOCATION - WORKAROUND";
    Boolean wsdlList;
    String frontEnd;
    String dataBinding;
    String wsdlVersion;
    String catalog;
    Boolean extendedSoapHeaders;
    Boolean validateWsdl;
    Boolean noTypes;
    Boolean useFQCNForFaultSerialVersionUID;
    Boolean markGenerated;
    String serviceName;
    Boolean autoNameResolution;
    Boolean noAddressBinding;
    Boolean allowElementRefs;

    public List<String> getExtraargs() {
        return this.extraargs;
    }

    public void setExtraargs(List<String> ea) {
        this.extraargs.clear();
        this.extraargs.addAll(ea);
    }

    public List<String> getXJCargs() {
        return this.xjcargs;
    }

    public void setXJCargs(List<String> ea) {
        this.xjcargs.clear();
        this.xjcargs.addAll(ea);
    }

    public List<String> getPackagenames() {
        return this.packagenames;
    }

    public void setPackagenames(List<String> pn) {
        this.packagenames = pn;
    }

    public List<String> getNamespaceExcludes() {
        return this.namespaceExcludes;
    }

    public void setNamespaceExcludes(List<String> namespaceExcludes) {
        this.namespaceExcludes = namespaceExcludes;
    }

    public void setDependencies(File[] files) {
        this.dependencies = files;
    }

    public File[] getDependencies() {
        return this.dependencies;
    }

    public void setDeleteDirs(File[] files) {
        this.redundantDirs = files;
    }

    public File[] getDeleteDirs() {
        return this.redundantDirs;
    }

    public File getOutputDir() {
        return this.outputDir;
    }

    public void setOutputDir(File f) {
        this.outputDir = f;
    }

    public void setBindingFiles(String[] files) {
        this.bindingFiles = files;
    }

    public String[] getBindingFiles() {
        return this.bindingFiles;
    }

    public void addBindingFile(File file) {
        String[] tmp = new String[this.bindingFiles.length + 1];
        System.arraycopy(this.bindingFiles, 0, tmp, 0, this.bindingFiles.length);
        this.bindingFiles = tmp;
        this.bindingFiles[this.bindingFiles.length - 1] = file.getAbsolutePath();
    }

    public void addDefaultBindingFileIfExists(File baseDir) {
        File defaultBindingFile = new File(baseDir, DEFAULT_BINDING_FILE_PATH);
        if (defaultBindingFile.exists()) {
            this.addBindingFile(defaultBindingFile);
        }
    }

    public void setWsdlLocation(String s) {
        this.wsdlLocation = s;
    }

    public String getWsdlLocation() {
        return this.isSetWsdlLocation() ? this.wsdlLocation : null;
    }

    public boolean isSetWsdlLocation() {
        return !DEFAULT_WSDL_LOCATION.equals(this.wsdlLocation);
    }

    public boolean isWsdlList() {
        return this.wsdlList == null ? false : this.wsdlList;
    }

    public void setWsdlList(boolean wsdlList) {
        this.wsdlList = wsdlList;
    }

    public String getFrontEnd() {
        return this.frontEnd;
    }

    public void setFrontEnd(String frontEnd) {
        this.frontEnd = frontEnd;
    }

    public String getDataBinding() {
        return this.dataBinding;
    }

    public void setDataBinding(String dataBinding) {
        this.dataBinding = dataBinding;
    }

    public String getWsdlVersion() {
        return this.wsdlVersion;
    }

    public void setWsdlVersion(String wsdlVersion) {
        this.wsdlVersion = wsdlVersion;
    }

    public String getCatalog() {
        return this.catalog;
    }

    public void setCatalog(String catalog) {
        this.catalog = catalog;
    }

    public boolean isExtendedSoapHeaders() {
        return this.extendedSoapHeaders == null ? false : this.extendedSoapHeaders;
    }

    public void setExtendedSoapHeaders(boolean extendedSoapHeaders) {
        this.extendedSoapHeaders = extendedSoapHeaders;
    }

    public boolean isValidateWsdl() {
        return this.validateWsdl == null ? false : this.validateWsdl;
    }

    public void setValidateWsdl(boolean validateWsdl) {
        this.validateWsdl = validateWsdl;
    }

    public boolean isNoTypes() {
        return this.noTypes == null ? false : this.noTypes;
    }

    public void setNoTypes(boolean noTypes) {
        this.noTypes = noTypes;
    }

    public boolean isUseFQCNForFaultSerialVersionUID() {
        return this.useFQCNForFaultSerialVersionUID == null ? false : this.useFQCNForFaultSerialVersionUID;
    }

    public void setUseFQCNForFaultSerialVersionUID(boolean useFQCNForFaultSerialVersionUID) {
        this.useFQCNForFaultSerialVersionUID = useFQCNForFaultSerialVersionUID;
    }

    public Boolean isMarkGenerated() {
        return this.markGenerated;
    }

    public void setMarkGenerated(Boolean markGenerated) {
        this.markGenerated = markGenerated;
    }

    public Boolean getDefaultExcludesNamespace() {
        return this.defaultExcludesNamespace;
    }

    public void setDefaultExcludesNamespace(Boolean defaultExcludesNamespace) {
        this.defaultExcludesNamespace = defaultExcludesNamespace;
    }

    public Boolean getDefaultNamespacePackageMapping() {
        return this.defaultNamespacePackageMapping;
    }

    public void setDefaultNamespacePackageMapping(Boolean defaultNamespacePackageMapping) {
        this.defaultNamespacePackageMapping = defaultNamespacePackageMapping;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public boolean isAutoNameResolution() {
        return this.autoNameResolution == null ? false : this.autoNameResolution;
    }

    public void setAutoNameResolution(boolean autoNameResolution) {
        this.autoNameResolution = autoNameResolution;
    }

    public boolean isNoAddressBinding() {
        return this.noAddressBinding == null ? false : this.noAddressBinding;
    }

    public void setNoAddressBinding(boolean noAddressBinding) {
        this.noAddressBinding = noAddressBinding;
    }

    public boolean isAllowElementRefs() {
        return this.allowElementRefs == null ? false : this.allowElementRefs;
    }

    public void setAllowElementRefs(boolean allowElementRefs) {
        this.allowElementRefs = allowElementRefs;
    }

    public void copyOptions(Option destination) {
        destination.setAutoNameResolution(this.isAutoNameResolution());
        destination.setBindingFiles(this.getBindingFiles());
        destination.setCatalog(this.getCatalog());
        destination.setDataBinding(this.getDataBinding());
        destination.setDefaultExcludesNamespace(this.getDefaultExcludesNamespace());
        destination.setDefaultNamespacePackageMapping(this.getDefaultNamespacePackageMapping());
        destination.setDeleteDirs(this.getDeleteDirs());
        destination.setDependencies(this.getDependencies());
        destination.setExtendedSoapHeaders(this.isExtendedSoapHeaders());
        destination.setExtraargs(this.getExtraargs());
        destination.setXJCargs(this.getXJCargs());
        destination.setFrontEnd(this.getFrontEnd());
        destination.setNamespaceExcludes(this.namespaceExcludes);
        destination.setNoAddressBinding(this.isNoAddressBinding());
        destination.setOutputDir(this.getOutputDir());
        destination.setPackagenames(this.getPackagenames());
        destination.setServiceName(this.getServiceName());
        destination.setValidateWsdl(this.isValidateWsdl());
        destination.setNoTypes(this.isNoTypes());
        destination.setUseFQCNForFaultSerialVersionUID(this.isUseFQCNForFaultSerialVersionUID());
        destination.setMarkGenerated(this.isMarkGenerated());
        destination.setAllowElementRefs(this.isAllowElementRefs());
        if (this.isSetWsdlLocation()) {
            destination.setWsdlLocation(this.getWsdlLocation());
        }
        destination.setWsdlVersion(this.getWsdlVersion());
    }

    private <T> T setIfNull(T dest, T source) {
        if (dest == null) {
            dest = source;
        }
        return dest;
    }

    public void merge(Option defaultOptions) {
        this.wsdlList = this.setIfNull(this.wsdlList, defaultOptions.wsdlList);
        this.extendedSoapHeaders = this.setIfNull(this.extendedSoapHeaders, defaultOptions.extendedSoapHeaders);
        this.noTypes = this.setIfNull(this.noTypes, defaultOptions.noTypes);
        this.validateWsdl = this.setIfNull(this.validateWsdl, defaultOptions.validateWsdl);
        this.useFQCNForFaultSerialVersionUID = this.setIfNull(this.useFQCNForFaultSerialVersionUID, defaultOptions.useFQCNForFaultSerialVersionUID);
        this.markGenerated = this.setIfNull(this.markGenerated, defaultOptions.markGenerated);
        this.autoNameResolution = this.setIfNull(this.autoNameResolution, defaultOptions.autoNameResolution);
        this.noAddressBinding = this.setIfNull(this.noAddressBinding, defaultOptions.noAddressBinding);
        this.allowElementRefs = this.setIfNull(this.allowElementRefs, defaultOptions.allowElementRefs);
        this.defaultExcludesNamespace = this.setIfNull(this.defaultExcludesNamespace, defaultOptions.defaultExcludesNamespace);
        this.defaultNamespacePackageMapping = this.setIfNull(this.defaultNamespacePackageMapping, defaultOptions.defaultNamespacePackageMapping);
        this.frontEnd = this.setIfNull(this.frontEnd, defaultOptions.frontEnd);
        this.dataBinding = this.setIfNull(this.dataBinding, defaultOptions.dataBinding);
        this.wsdlVersion = this.setIfNull(this.wsdlVersion, defaultOptions.wsdlVersion);
        this.catalog = this.setIfNull(this.catalog, defaultOptions.catalog);
        this.serviceName = this.setIfNull(this.serviceName, defaultOptions.serviceName);
        this.outputDir = this.setIfNull(this.outputDir, defaultOptions.outputDir);
        this.extraargs.addAll(defaultOptions.extraargs);
        this.xjcargs.addAll(defaultOptions.xjcargs);
        this.bindingFiles = this.mergeList(this.bindingFiles, defaultOptions.bindingFiles, String.class);
        this.dependencies = this.mergeList(this.dependencies, defaultOptions.dependencies, File.class);
        this.redundantDirs = this.mergeList(this.redundantDirs, defaultOptions.redundantDirs, File.class);
        this.packagenames.addAll(defaultOptions.packagenames);
        this.namespaceExcludes.addAll(defaultOptions.namespaceExcludes);
    }

    private <T> T[] mergeList(T[] l1, T[] l2, Class<T> cls) {
        if (l1 == null) {
            return l2;
        }
        if (l2 == null) {
            return l1;
        }
        int len = l1.length + l2.length;
        Object[] ret = (Object[])Array.newInstance(cls, len);
        System.arraycopy(l1, 0, ret, 0, l1.length);
        System.arraycopy(l2, 0, ret, l1.length, l2.length);
        return ret;
    }
}

