/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.maven_plugin;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.maven_plugin.Option;
import org.apache.cxf.maven_plugin.WsdlArtifact;
import org.apache.cxf.maven_plugin.WsdlOption;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.FileUtils;

public final class WsdlOptionLoader {
    private static final String WSDL_TYPE = "wsdl";
    private static final String WSDL_OPTIONS = "-options$";
    private static final String WSDL_BINDINGS = "-binding-?\\d*.xml$";

    private WsdlOptionLoader() {
    }

    public static List<WsdlOption> loadWsdlOptionsFromDependencies(MavenProject project, Option defaultOptions, File outputDir) {
        ArrayList<WsdlOption> options = new ArrayList<WsdlOption>();
        Set dependencies = project.getDependencyArtifacts();
        for (Artifact artifact : dependencies) {
            WsdlOption option = WsdlOptionLoader.generateWsdlOptionFromArtifact(artifact, outputDir);
            if (option == null) continue;
            if (defaultOptions != null) {
                option.merge(defaultOptions);
            }
            options.add(option);
        }
        return options;
    }

    private static WsdlOption generateWsdlOptionFromArtifact(Artifact artifact, File outputDir) {
        if (!WSDL_TYPE.equals(artifact.getType())) {
            return null;
        }
        WsdlOption option = new WsdlOption();
        WsdlArtifact wsdlArtifact = new WsdlArtifact();
        wsdlArtifact.setArtifactId(artifact.getArtifactId());
        wsdlArtifact.setGroupId(artifact.getGroupId());
        wsdlArtifact.setType(artifact.getType());
        wsdlArtifact.setVersion(artifact.getVersion());
        option.setWsdlArtifact(wsdlArtifact);
        option.setOutputDir(outputDir);
        return option;
    }

    public static List<WsdlOption> loadWsdlOptionsFromFiles(File wsdlBasedir, String[] includes, String[] excludes, Option defaultOptions, File defaultOutputDir) throws MojoExecutionException {
        if (wsdlBasedir == null) {
            return new ArrayList<WsdlOption>();
        }
        if (!wsdlBasedir.exists()) {
            throw new MojoExecutionException(wsdlBasedir + " does not exist");
        }
        List<File> wsdlFiles = WsdlOptionLoader.getWsdlFiles(wsdlBasedir, includes, excludes);
        ArrayList<WsdlOption> wsdlOptions = new ArrayList<WsdlOption>();
        for (File wsdl : wsdlFiles) {
            WsdlOption wsdlOption = WsdlOptionLoader.generateWsdlOptionFromFile(wsdl, defaultOptions, defaultOutputDir);
            if (wsdlOption == null) continue;
            wsdlOptions.add(wsdlOption);
        }
        return wsdlOptions;
    }

    private static String joinWithComma(String[] arr) {
        if (arr == null) {
            return "";
        }
        StringBuilder str = new StringBuilder();
        if (arr != null) {
            for (String s : arr) {
                if (str.length() > 0) {
                    str.append(',');
                }
                str.append(s);
            }
        }
        return str.toString();
    }

    private static List<File> getWsdlFiles(File dir, String[] includes, String[] excludes) throws MojoExecutionException {
        ArrayList<String> exList = new ArrayList<String>();
        if (excludes != null) {
            exList.addAll(Arrays.asList(excludes));
        }
        exList.addAll(Arrays.asList(FileUtils.getDefaultExcludes()));
        String inc = WsdlOptionLoader.joinWithComma(includes);
        String ex = WsdlOptionLoader.joinWithComma(exList.toArray(new String[exList.size()]));
        try {
            List newfiles = FileUtils.getFiles((File)dir, (String)inc, (String)ex);
            return CastUtils.cast((List)newfiles);
        }
        catch (IOException exc) {
            throw new MojoExecutionException(exc.getMessage(), (Exception)exc);
        }
    }

    private static String[] readOptionsFromFile(File dir, String wsdlName) throws MojoExecutionException {
        String[] noOptions = new String[]{};
        List files = org.apache.cxf.helpers.FileUtils.getFiles((File)dir, (String)(wsdlName + WSDL_OPTIONS));
        if (files.size() <= 0) {
            return noOptions;
        }
        File optionsFile = (File)files.iterator().next();
        if (optionsFile == null || !optionsFile.exists()) {
            return noOptions;
        }
        try {
            List lines = org.apache.cxf.helpers.FileUtils.readLines((File)optionsFile);
            if (lines.size() <= 0) {
                return noOptions;
            }
            return ((String)lines.iterator().next()).split(" ");
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error reading options from file " + optionsFile.getAbsolutePath(), e);
        }
    }

    protected static WsdlOption generateWsdlOptionFromFile(File wsdl, Option defaultOptions, File defaultOutputDir) throws MojoExecutionException {
        if (wsdl == null || !wsdl.exists()) {
            return null;
        }
        String wsdlFileName = wsdl.getName();
        int idx = wsdlFileName.toLowerCase().lastIndexOf(".wsdl");
        if (idx == -1) {
            idx = wsdlFileName.lastIndexOf(46);
        }
        if (idx == -1) {
            return null;
        }
        WsdlOption wsdlOption = new WsdlOption();
        String wsdlName = wsdlFileName.substring(0, idx);
        String[] options = WsdlOptionLoader.readOptionsFromFile(wsdl.getParentFile(), wsdlName);
        if (options.length > 0) {
            wsdlOption.getExtraargs().addAll(Arrays.asList(options));
        } else if (defaultOptions != null) {
            defaultOptions.copyOptions(wsdlOption);
        }
        List bindingFiles = org.apache.cxf.helpers.FileUtils.getFiles((File)wsdl.getParentFile(), (String)(wsdlName + WSDL_BINDINGS));
        if (bindingFiles != null) {
            for (File binding : bindingFiles) {
                wsdlOption.addBindingFile(binding);
            }
        }
        wsdlOption.setWsdl(wsdl.toURI().toString());
        if (wsdlOption.getOutputDir() == null) {
            wsdlOption.setOutputDir(defaultOutputDir);
        }
        return wsdlOption;
    }
}

