/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.wsstar.topics.datatypes.api.utils;

import com.ebmwebsourcing.wsstar.topics.datatypes.api.abstraction.TopicNamespaceType;
import com.ebmwebsourcing.wsstar.topics.datatypes.api.abstraction.TopicSetType;
import com.ebmwebsourcing.wsstar.topics.datatypes.api.abstraction.TopicType;
import com.ebmwebsourcing.wsstar.topics.datatypes.api.refinedabstraction.RefinedWstopFactory;
import com.ebmwebsourcing.wsstar.topics.datatypes.api.utils.SOAUtil;
import com.ebmwebsourcing.wsstar.topics.datatypes.api.utils.WstopException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class WstopDatatypeUtils {
    private WstopDatatypeUtils() {
    }

    public static TopicSetType addTopicsFromTopicNamespaceToTopicSet(TopicSetType topicSet, TopicNamespaceType topicNamespace, String prefixToUse) throws WstopException {
        TopicSetType result = RefinedWstopFactory.getInstance().createTopicSetType();
        for (Element treeItem : topicSet.getTopicsTrees()) {
            result.addTopicsTree(treeItem);
        }
        List<Element> topicsToAddToTopicSet = WstopDatatypeUtils.fromTopicNamespaceToTopicTreesElt(topicNamespace, prefixToUse);
        for (Element topicTreeItem : topicsToAddToTopicSet) {
            result.addTopicsTree(topicTreeItem);
        }
        return result;
    }

    private static List<Element> fromTopicNamespaceToTopicTreesElt(TopicNamespaceType topicNamespace, String prefixToUse) throws WstopException {
        ArrayList<Element> treesElt = new ArrayList<Element>();
        List<TopicNamespaceType.Topic> topicsFromTopicNs = topicNamespace.getTopics();
        Document doc = null;
        try {
            doc = SOAUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException e) {
            throw new WstopException(e);
        }
        List<TopicType> children = null;
        for (TopicNamespaceType.Topic topicItem : topicsFromTopicNs) {
            Element currentTopicTree = doc.createElementNS(topicNamespace.getNamespace().toString(), topicItem.getName());
            Attr topicAttr = doc.createAttributeNS("http://docs.oasis-open.org/wsn/t-1", "topic");
            topicAttr.setPrefix("wstop");
            topicAttr.setNodeValue("true");
            currentTopicTree.setPrefix(prefixToUse);
            currentTopicTree.setAttributeNodeNS(topicAttr);
            children = topicItem.getTopics();
            if (children != null && children.size() > 0) {
                try {
                    currentTopicTree.appendChild(WstopDatatypeUtils.addChildren(currentTopicTree, topicItem.getTopics(), doc, (Attr)topicAttr.cloneNode(true)));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            treesElt.add(currentTopicTree);
        }
        return treesElt;
    }

    private static Element addChildren(Element parentTopicElt, List<TopicType> childTopics, Document docToBuildElt, Attr topicAttr) {
        Element result = null;
        Element currentChild = null;
        List<TopicType> children = null;
        for (TopicType topicItem : childTopics) {
            currentChild = docToBuildElt.createElement(topicItem.getName());
            currentChild.setAttributeNodeNS((Attr)topicAttr.cloneNode(true));
            children = topicItem.getTopics();
            if (children == null || children.size() <= 0) continue;
            parentTopicElt.appendChild(WstopDatatypeUtils.addChildren(currentChild, topicItem.getTopics(), docToBuildElt, (Attr)topicAttr.cloneNode(true)));
        }
        return result;
    }
}

