/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.component.framework;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.jbi.JBIException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.ow2.petals.component.framework.ExtensionMBean;
import org.ow2.petals.component.framework.JBIBootstrap;
import org.ow2.petals.component.framework.api.exception.PEtALSCDKException;
import org.ow2.petals.component.framework.api.util.PropertiesUtil;
import org.ow2.petals.component.framework.jbidescriptor.CDKJBIDescriptorException;
import org.ow2.petals.component.framework.jbidescriptor.JBIDescriptorBuilder;
import org.ow2.petals.component.framework.jbidescriptor.generated.Jbi;
import org.ow2.petals.component.framework.jbidescriptor.generated.SettableanyURI;
import org.ow2.petals.component.framework.mbean.MBeanHelper;
import org.ow2.petals.component.framework.util.StringHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultBootstrap
extends JBIBootstrap {
    protected ObjectName mbeanName;

    @Override
    public ObjectName getExtensionMBeanName() {
        MBeanServer server = this.installContext.getContext().getMBeanServer();
        ObjectName objName = server.isRegistered(this.mbeanName) ? this.mbeanName : null;
        return objName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onInstall() throws JBIException {
        File jbiXmlFile = new File(this.getInstallContext().getInstallRoot() + File.separator + "META-INF" + File.separator + "jbi.xml");
        this.validateComponentSettableConfiguration();
        try {
            FileOutputStream jbiOutputStream = new FileOutputStream(jbiXmlFile);
            try {
                JBIDescriptorBuilder.buildXmlJBIdescriptor((Jbi)this.getJbiComponentConfiguration(), (OutputStream)jbiOutputStream);
                Object var4_5 = null;
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                jbiOutputStream.close();
                throw throwable;
            }
            jbiOutputStream.close();
            {
            }
        }
        catch (IOException e) {
            throw new JBIException("Failed to persist the installation configuration : " + e.getMessage());
        }
        catch (CDKJBIDescriptorException e) {
            throw new JBIException("Failed to persist the installation configuration : " + e.getMessage());
        }
    }

    @Override
    public void cleanUp() throws JBIException {
        MBeanServer server = this.installContext.getContext().getMBeanServer();
        if (server.isRegistered(this.mbeanName)) {
            try {
                server.unregisterMBean(this.mbeanName);
            }
            catch (InstanceNotFoundException e) {
                throw new JBIException("Error during bootstrap clean up : " + e.getMessage());
            }
            catch (MBeanRegistrationException e) {
                throw new JBIException("Error during bootstrap clean up" + e.getMessage());
            }
        }
    }

    @Override
    protected void doInit() throws JBIException {
        this.mbeanName = this.installContext.getContext().getMBeanNames().createCustomComponentMBeanName("bootstrap_" + this.installContext.getComponentName());
        MBeanHelper.registerMBean(this.installContext.getContext().getMBeanServer(), this.mbeanName, new ExtensionMBean(this));
    }

    protected List<String> getMethodList() {
        return new ArrayList<String>();
    }

    protected List<String> getAttributeList() {
        return new ArrayList<String>();
    }

    private void validateComponentSettableConfiguration() throws JBIException {
        SettableanyURI propertiesFile = this.getJbiComponentConfiguration().getComponent().getPropertiesFile();
        if (propertiesFile != null && !StringHelper.isNullOrEmpty(propertiesFile.getValue())) {
            try {
                PropertiesUtil.loadProperties((String)propertiesFile.getValue());
            }
            catch (PEtALSCDKException e) {
                throw new JBIException(e.getMessage());
            }
        }
    }
}

