/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.component.framework.util;

import java.io.File;
import java.io.FilenameFilter;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileNamePatternUtil {
    private static FileNamePatternUtil instance = new FileNamePatternUtil();

    private FileNamePatternUtil() {
    }

    public static FileNamePatternUtil getInstance() {
        return instance;
    }

    public RegexFileNameFilter buildFileNameFilterFromRegex(String regex) {
        return new RegexFileNameFilter(regex);
    }

    public RegexFileNameFilter buildFileNameFilterFromWildChar(String wildChar) {
        return new RegexFileNameFilter(this.wildcharToRegex(wildChar));
    }

    public RegexFileNameFilter buildFileNameFilterFromFilters(List<RegexFileNameFilter> filters) {
        return new RegexFileNameFilterList(filters);
    }

    public String regexToWildchar(String regex) {
        String a = regex.replaceAll("\\\\.", "\u00b2");
        String b = a.replaceAll("\\.", "?");
        String c = b.replaceAll("\u00b2", ".");
        return c;
    }

    public String wildcharToRegex(String wildChar) {
        return wildChar.replaceAll("\\.", "\\\\.").replace("*", ".*").replaceAll("\\?", ".");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class RegexFileNameFilterList
    extends RegexFileNameFilter {
        private List<RegexFileNameFilter> list;

        public RegexFileNameFilterList(List<RegexFileNameFilter> list) {
            this.list = list;
        }

        @Override
        public boolean accept(File dir, String name) {
            boolean accept = false;
            Iterator<RegexFileNameFilter> iterator = this.list.iterator();
            while (iterator.hasNext() && !accept) {
                accept = iterator.next().accept(null, name);
            }
            return accept;
        }
    }

    public class RegexFileNameFilter
    implements FilenameFilter {
        private static final String ANY_VALUE = ".*";
        private String regex;

        public RegexFileNameFilter() {
            this(ANY_VALUE);
        }

        public RegexFileNameFilter(String regex) {
            this.regex = regex;
        }

        public boolean accept(File dir, String name) {
            return Pattern.compile(this.regex, 2).matcher(name).matches();
        }
    }
}

