/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.dsb.notification.commons;

import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.Subscribe;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.xml.namespace.QName;
import org.petalslink.dsb.notification.commons.NotificationException;
import org.petalslink.dsb.notification.commons.NotificationHelper;
import org.petalslink.dsb.notification.commons.api.ConfigurationProducer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertiesConfigurationProducer
implements ConfigurationProducer {
    private Properties properties;

    public PropertiesConfigurationProducer(Properties props) {
        this.properties = props;
    }

    @Override
    public Map<String, Subscribe> getSubscribe() {
        HashMap<String, Subscribe> result = new HashMap<String, Subscribe>();
        if (this.properties == null) {
            return result;
        }
        Set<String> keys = PropertiesConfigurationProducer.getAllKeys(this.properties);
        for (String string : keys) {
            Subscribe subscribe = this.load(this.properties, string);
            if (subscribe == null) continue;
            result.put(string, subscribe);
        }
        return result;
    }

    private Subscribe load(Properties properties, String key) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (Object o : properties.keySet()) {
            String k = o.toString();
            if (!k.startsWith(String.valueOf(key) + ".")) continue;
            map.put(k.substring(key.length() + 1), properties.getProperty(k));
        }
        if (map.size() == 0) {
            return null;
        }
        return this.load(map);
    }

    private Subscribe load(Map<String, String> map) {
        Subscribe result = null;
        String url = map.get("consumerReference");
        String topic = map.get("topicName");
        String topicPrefix = map.get("topicPrefix");
        String topicURI = map.get("topicURI");
        if (url != null && topic != null && topicPrefix != null && topicURI != null) {
            QName topicName = new QName(topicURI, topic, topicPrefix);
            try {
                result = NotificationHelper.createSubscribe(url, topicName);
            }
            catch (NotificationException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public static Set<String> getAllKeys(Properties props) {
        HashSet<String> result = new HashSet<String>();
        if (props == null) {
            return result;
        }
        for (Object o : props.keySet()) {
            String key = o.toString();
            if (key.indexOf(46) <= 0 || key.indexOf(46) == key.length()) continue;
            result.add(key.substring(0, key.indexOf(46)));
        }
        return result;
    }

    public String getProperty(String key, String name) {
        return this.properties.getProperty(String.valueOf(key) + "." + name);
    }
}

