/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.interceptor.security;

import java.util.ResourceBundle;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.cxf.common.i18n.BundleUtils;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.security.SecurityToken;
import org.apache.cxf.common.security.TokenType;
import org.apache.cxf.common.security.UsernameToken;
import org.apache.cxf.configuration.security.AuthorizationPolicy;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.security.AuthenticationException;
import org.apache.cxf.interceptor.security.DefaultSecurityContext;
import org.apache.cxf.interceptor.security.NamePasswordCallbackHandler;
import org.apache.cxf.interceptor.security.RolePrefixSecurityContextImpl;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.security.SecurityContext;

public class JAASLoginInterceptor
extends AbstractPhaseInterceptor<Message> {
    private static final ResourceBundle BUNDLE = BundleUtils.getBundle(JAASLoginInterceptor.class);
    private static final Logger LOG = LogUtils.getL7dLogger(JAASLoginInterceptor.class);
    private String contextName;
    private String rolePrefix;

    public JAASLoginInterceptor() {
        super("unmarshal");
    }

    public void setContextName(String name) {
        this.contextName = name;
    }

    public String getContextName() {
        return this.contextName;
    }

    public void setRolePrefix(String name) {
        this.rolePrefix = name;
    }

    public String getRolePrefix() {
        return this.rolePrefix;
    }

    public void handleMessage(Message message) throws Fault {
        String name = null;
        String password = null;
        AuthorizationPolicy policy = (AuthorizationPolicy)message.get(AuthorizationPolicy.class);
        if (policy != null) {
            name = policy.getUserName();
            password = policy.getPassword();
        } else {
            SecurityToken token = (SecurityToken)message.get(SecurityToken.class);
            if (token != null && token.getTokenType() == TokenType.UsernameToken) {
                UsernameToken ut = (UsernameToken)token;
                name = ut.getName();
                password = ut.getPassword();
            }
        }
        if (name == null || password == null) {
            org.apache.cxf.common.i18n.Message errorMsg = new org.apache.cxf.common.i18n.Message("NO_USER_PASSWORD", BUNDLE, new Object[]{name, password});
            LOG.warning(errorMsg.toString());
            throw new SecurityException(errorMsg.toString());
        }
        try {
            CallbackHandler handler = this.getCallbackHandler(name, password);
            LoginContext ctx = new LoginContext(this.getContextName(), handler);
            ctx.login();
            Subject subject = ctx.getSubject();
            message.put(SecurityContext.class, (Object)this.createSecurityContext(subject));
        }
        catch (LoginException ex) {
            String errorMessage = "Unauthorized : " + ex.getMessage();
            LOG.fine(errorMessage.toString());
            throw new AuthenticationException(errorMessage);
        }
    }

    protected CallbackHandler getCallbackHandler(String name, String password) {
        return new NamePasswordCallbackHandler(name, password);
    }

    protected SecurityContext createSecurityContext(Subject subject) {
        if (this.getRolePrefix() != null) {
            return new RolePrefixSecurityContextImpl(subject, this.getRolePrefix());
        }
        return new DefaultSecurityContext(subject);
    }
}

