/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.buslifecycle;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.annotation.Resource;
import org.apache.cxf.Bus;
import org.apache.cxf.buslifecycle.BusLifeCycleListener;
import org.apache.cxf.buslifecycle.BusLifeCycleManager;
import org.apache.cxf.common.injection.NoJSR250Annotations;

@NoJSR250Annotations(unlessNull={"bus"})
public class CXFBusLifeCycleManager
implements BusLifeCycleManager {
    private final List<BusLifeCycleListener> listeners = new CopyOnWriteArrayList<BusLifeCycleListener>();
    private Bus bus;
    private boolean preShutdownCalled;
    private boolean postShutdownCalled;

    public CXFBusLifeCycleManager() {
    }

    public CXFBusLifeCycleManager(Bus b) {
        this.setBus(b);
    }

    @Resource
    public final void setBus(Bus b) {
        this.bus = b;
        if (null != this.bus) {
            this.bus.setExtension(this, BusLifeCycleManager.class);
        }
    }

    @Override
    public void registerLifeCycleListener(BusLifeCycleListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void unregisterLifeCycleListener(BusLifeCycleListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void initComplete() {
        this.preShutdownCalled = false;
        this.postShutdownCalled = false;
        for (BusLifeCycleListener listener : this.listeners) {
            listener.initComplete();
        }
    }

    @Override
    public void preShutdown() {
        if (!this.preShutdownCalled) {
            this.preShutdownCalled = true;
            for (BusLifeCycleListener listener : this.listeners) {
                listener.preShutdown();
            }
        }
    }

    @Override
    public void postShutdown() {
        if (!this.preShutdownCalled) {
            this.preShutdown();
        }
        if (!this.postShutdownCalled) {
            this.postShutdownCalled = true;
            for (BusLifeCycleListener listener : this.listeners) {
                listener.postShutdown();
            }
        }
    }
}

