/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.common.logging;

import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.apache.cxf.common.logging.AbstractDelegatingLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Slf4jLogger
extends AbstractDelegatingLogger {
    private final Logger logger;

    public Slf4jLogger(String name, String resourceBundleName) {
        super(name, resourceBundleName);
        this.logger = LoggerFactory.getLogger((String)name);
    }

    @Override
    public Level getLevel() {
        Level level = this.logger.isTraceEnabled() ? Level.FINER : (this.logger.isDebugEnabled() ? Level.FINER : (this.logger.isInfoEnabled() ? Level.INFO : (this.logger.isWarnEnabled() ? Level.WARNING : (this.logger.isErrorEnabled() ? Level.SEVERE : Level.OFF))));
        return level;
    }

    @Override
    protected void internalLogFormatted(String msg, LogRecord record) {
        Level level = record.getLevel();
        Throwable t = record.getThrown();
        if (Level.FINE.equals(level)) {
            this.logger.debug(msg, t);
        } else if (Level.INFO.equals(level)) {
            this.logger.info(msg, t);
        } else if (Level.WARNING.equals(level)) {
            this.logger.warn(msg, t);
        } else if (Level.FINER.equals(level)) {
            this.logger.trace(msg, t);
        } else if (Level.FINEST.equals(level)) {
            this.logger.trace(msg, t);
        } else if (Level.ALL.equals(level)) {
            this.logger.error(msg, t);
        } else if (Level.SEVERE.equals(level)) {
            this.logger.error(msg, t);
        } else if (Level.CONFIG.equals(level)) {
            this.logger.debug(msg, t);
        } else if (Level.OFF.equals(level)) {
            // empty if block
        }
    }
}

