/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.common.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.jws.soap.SOAPBinding;
import javax.wsdl.OperationType;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.tools.common.ToolException;
import org.apache.cxf.tools.common.model.Annotator;
import org.apache.cxf.tools.common.model.JAnnotation;
import org.apache.cxf.tools.common.model.JavaAnnotatable;
import org.apache.cxf.tools.common.model.JavaCodeBlock;
import org.apache.cxf.tools.common.model.JavaException;
import org.apache.cxf.tools.common.model.JavaInterface;
import org.apache.cxf.tools.common.model.JavaParameter;
import org.apache.cxf.tools.common.model.JavaReturn;
import org.apache.cxf.tools.common.model.JavaType;

public class JavaMethod
implements JavaAnnotatable {
    private static final Logger LOG = LogUtils.getL7dLogger(JavaMethod.class);
    private static final Map<String, String> PRIMITIVE_MAP = new HashMap<String, String>();
    private String name;
    private String operationName;
    private String javaDoc;
    private JavaReturn javaReturn;
    private OperationType style;
    private String soapAction;
    private SOAPBinding.Style soapStyle;
    private SOAPBinding.Use soapUse;
    private boolean wrapperStyle;
    private boolean enableMime;
    private JavaInterface javaInterface;
    private final List<JavaParameter> parameters = new ArrayList<JavaParameter>();
    private final List<JavaException> exceptions = new ArrayList<JavaException>();
    private final Map<String, JAnnotation> annotations = new HashMap<String, JAnnotation>();
    private JavaCodeBlock block;
    private boolean async;

    public JavaMethod() {
        this(new JavaInterface());
    }

    public JavaMethod(JavaInterface i) {
        this.javaInterface = i;
        this.javaReturn = new JavaReturn();
    }

    public void clear() {
        this.parameters.clear();
        this.javaReturn = new JavaReturn();
    }

    public String getSignature() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.javaReturn.getName());
        sb.append("#");
        sb.append(this.javaInterface.getPackageName());
        sb.append(".");
        sb.append(this.javaInterface.getName());
        sb.append("#");
        sb.append(this.name);
        sb.append("[");
        for (JavaParameter param : this.parameters) {
            sb.append(param.getName());
            sb.append(",");
        }
        sb.append("]");
        return sb.toString();
    }

    public JavaInterface getInterface() {
        return this.javaInterface;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String n) {
        this.name = n;
    }

    public String getOperationName() {
        return this.operationName;
    }

    public void setOperationName(String arg) {
        this.operationName = arg;
    }

    public JavaReturn getReturn() {
        return this.javaReturn;
    }

    public String getReturnValue() {
        String value = this.getClassName(this.javaReturn);
        return value == null ? "void" : value;
    }

    public void setReturn(JavaReturn rt) {
        if (rt != null && rt.getType() == null && rt.getClassName() == null) {
            Message msg = new Message("FAIL_TO_CREATE_JAVA_OUTPUT_PARAMETER", LOG, rt.name, this.getName());
            throw new ToolException(msg);
        }
        this.javaReturn = rt;
    }

    public boolean hasParameter(String paramName) {
        for (int i = 0; i < this.parameters.size(); ++i) {
            if (!paramName.equals(this.parameters.get(i).getName())) continue;
            return true;
        }
        return false;
    }

    private void replaceParameter(JavaParameter p1, JavaParameter p2) {
        int index = ((ArrayList)this.parameters).indexOf(p1);
        this.parameters.remove(index);
        this.parameters.add(index, p2);
        if (p1.isIN() && p2.isOUT() || p1.isINOUT()) {
            p2.setStyle(JavaType.Style.INOUT);
        }
    }

    private boolean isEquiv(String c1, String c2) {
        String s = PRIMITIVE_MAP.get(c2);
        if (s != null && c1.equals(s)) {
            return true;
        }
        return c1.equals(c2);
    }

    public void addParameter(JavaParameter param) {
        if (this.hasParameter(param.getName())) {
            JavaParameter paramInList = this.getParameter(param.getName());
            if (this.isEquiv(paramInList.getClassName(), param.getClassName()) && paramInList.isIN() || paramInList.isINOUT()) {
                this.replaceParameter(paramInList, param);
                return;
            }
            Message message = new Message("PARAMETER_ALREADY_EXIST", LOG, param.getName(), this.getName(), paramInList.getType(), param.getType());
            throw new ToolException(message);
        }
        if (param.getType() == null && param.getClassName() == null) {
            Message msg = new Message("FAIL_TO_CREATE_JAVA_PARAMETER", LOG, param.name, this.getName());
            throw new ToolException(msg);
        }
        param.setMethod(this);
        this.parameters.add(param);
    }

    public JavaParameter getParameter(String paramName) {
        for (int i = 0; i < this.parameters.size(); ++i) {
            JavaParameter jParam = this.parameters.get(i);
            if (!paramName.equals(jParam.getName())) continue;
            return jParam;
        }
        return null;
    }

    public List<JavaParameter> getParameters() {
        return this.parameters;
    }

    public int getParameterCount() {
        return this.parameters.size();
    }

    public boolean hasException(JavaException exception) {
        return this.exceptions.contains(exception);
    }

    public void addException(JavaException exception) {
        if (this.hasException(exception)) {
            Message message = new Message("EXCEPTION_ALREADY_EXIST", LOG, exception.getName());
            throw new ToolException(message);
        }
        this.exceptions.add(exception);
    }

    public List<JavaException> getExceptions() {
        return this.exceptions;
    }

    public OperationType getStyle() {
        return this.style;
    }

    public void setStyle(OperationType ot) {
        this.style = ot;
    }

    public boolean isOneWay() {
        return OperationType.ONE_WAY.equals(this.getStyle());
    }

    public boolean isWrapperStyle() {
        return this.wrapperStyle;
    }

    public void setWrapperStyle(boolean w) {
        this.wrapperStyle = w;
    }

    public boolean enableMime() {
        return this.enableMime;
    }

    public void setMimeEnable(boolean arg) {
        this.enableMime = arg;
    }

    public void setSoapStyle(SOAPBinding.Style sty) {
        this.soapStyle = sty;
    }

    public SOAPBinding.Style getSoapStyle() {
        return this.soapStyle;
    }

    public void setSoapAction(String action) {
        this.soapAction = action;
    }

    public String getSoapAction() {
        return this.soapAction;
    }

    public void setSoapUse(SOAPBinding.Use u) {
        this.soapUse = u;
    }

    public SOAPBinding.Use getSoapUse() {
        return this.soapUse;
    }

    public void addAnnotation(String tag, JAnnotation annotation) {
        if (annotation == null) {
            return;
        }
        this.annotations.put(tag, annotation);
        for (String importClz : annotation.getImports()) {
            this.getInterface().addImport(importClz);
        }
    }

    public Collection<JAnnotation> getAnnotations() {
        return this.annotations.values();
    }

    public Map<String, JAnnotation> getAnnotationMap() {
        return this.annotations;
    }

    public List<String> getParameterList() {
        return this.getParameterList(true);
    }

    public List<String> getParameterListWithoutAnnotation() {
        return this.getParameterList(false);
    }

    private String getClassName(JavaType type) {
        if (this.getInterface() == null || this.getInterface().getPackageName() == null) {
            return type.getClassName();
        }
        if (this.getInterface().getPackageName().equals(type.getPackageName())) {
            return type.getSimpleName();
        }
        return type.getClassName();
    }

    public List<String> getParameterList(boolean includeAnnotation) {
        ArrayList<String> list = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.parameters.size(); ++i) {
            JavaParameter parameter = this.parameters.get(i);
            if (includeAnnotation && parameter.getAnnotations().size() > 0) {
                for (JAnnotation jan : parameter.getAnnotations()) {
                    list.add(jan.toString());
                }
            }
            sb.setLength(0);
            if (parameter.isHolder()) {
                sb.append(parameter.getHolderName());
                sb.append("<");
                sb.append(this.getClassName(parameter));
                sb.append(">");
            } else {
                sb.append(this.getClassName(parameter));
            }
            sb.append(" ");
            sb.append(parameter.getName());
            if (i != this.parameters.size() - 1) {
                sb.append(',');
            }
            list.add(sb.toString());
        }
        return list;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("\n========================\n");
        sb.append("\nMethod:");
        sb.append(this.getName());
        sb.append("\n-----------\n");
        sb.append("\nReturn:");
        sb.append(this.getReturn());
        sb.append("\n------------\n");
        sb.append("\nParameter:");
        sb.append(this.getParameterList());
        sb.append("\n------------\n");
        sb.append("\nAnnotations:");
        sb.append(this.getAnnotations());
        sb.append("\n========================\n");
        return sb.toString();
    }

    public void setInterface(JavaInterface intf) {
        this.javaInterface = intf;
    }

    @Override
    public void annotate(Annotator annotator) {
        annotator.annotate(this);
    }

    public void setJavaCodeBlock(JavaCodeBlock b) {
        this.block = b;
    }

    public JavaCodeBlock getJavaCodeBlock() {
        return this.block;
    }

    public final boolean isAsync() {
        return this.async;
    }

    public final void setAsync(boolean newAsync) {
        this.async = newAsync;
    }

    public void setJavaDoc(String doc) {
        this.javaDoc = doc;
    }

    public String getJavaDoc() {
        return this.javaDoc != null ? this.javaDoc : "";
    }

    static {
        PRIMITIVE_MAP.put("java.lang.Character", "char");
        PRIMITIVE_MAP.put("java.lang.Boolean", "boolean");
        PRIMITIVE_MAP.put("java.lang.Integer", "int");
        PRIMITIVE_MAP.put("java.lang.Long", "long");
        PRIMITIVE_MAP.put("java.lang.Short", "short");
        PRIMITIVE_MAP.put("java.lang.Byte", "byte");
        PRIMITIVE_MAP.put("java.lang.Float", "float");
        PRIMITIVE_MAP.put("java.lang.Double", "double");
    }
}

